/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListMap;

@Ser
public class AddressTreeMap<V>
extends ConcurrentSkipListMap<Long, V> {
    private static final long serialVersionUID = 1L;
    @SerId(value=1)
    private long invmask;

    @SerConstructor
    private AddressTreeMap() {
        this(1);
    }

    public AddressTreeMap(int n) {
        super(new Comparator<Long>(){

            @Override
            public int compare(Long l2, Long l3) {
                return Longs.compareUnsigned(l2, l3);
            }
        });
        if (n <= 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        this.invmask = MathUtil.makeInverseMask(n);
    }

    @Override
    public V put(Long l2, V v2) {
        if ((l2 & this.invmask) != 0L) {
            throw new IllegalArgumentException(String.format("Illegal address: 0x%X", l2));
        }
        return super.put(l2, v2);
    }
}

