/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.wasm;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.wasm.PQ;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WasmIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "wasm";

    public WasmIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("WebAssembly module", "WebAssembly Module (wasm v1) binary blob parser", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!WasmIdentifier.checkBytes(iInput, 0, 0, 97, 115, 109)) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() < 64) {
            return false;
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt(4);
        return n == 1;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        PQ pQ = new PQ(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return pQ;
    }
}

