/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.gzip;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IDataProvider;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IArchiveUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.impl.DataContainerUnit;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

@Ser
public class OI
extends AbstractBinaryUnit
implements IDataProvider,
IArchiveUnit {
    private static final ILogger eO = GlobalLog.getLogger(OI.class);

    public OI(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super("application/gzip", iInput, "gzip", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public byte[] getDataBytes(String string, int n) {
        return new byte[0];
    }

    @Override
    public long getDataSize(String string, int n) {
        return 0L;
    }

    @Override
    protected boolean processInternal() {
        TreeMap treeMap = new TreeMap();
        try (GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream(this.getInput().getStream());){
            int n = 0;
            try {
                while (true) {
                    int n2;
                    int n3;
                    GzipParameters gzipParameters;
                    String string;
                    if ((string = (gzipParameters = gzipCompressorInputStream.getMetaData()).getFilename()) == null && (n3 = (string = this.getName()).lastIndexOf(46)) >= 0) {
                        string = string.substring(0, n3);
                    }
                    if (treeMap.containsKey(string)) {
                        string = string + "." + n;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n4 = 0;
                    byte[] byArray = new byte[16384];
                    while ((n2 = gzipCompressorInputStream.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                        ++n4;
                    }
                    if (n4 == 0) {
                        break;
                    }
                    byteArrayOutputStream.flush();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    DataContainerUnit.Entry entry = DataContainerUnit.Entry.create(string, byArray2);
                    Maps.putNoOverwrite(treeMap, string, entry);
                    ++n;
                }
            }
            catch (IOException iOException) {
                eO.catching(iOException);
            }
        }
        catch (IOException iOException) {
            eO.catching(iOException);
            return false;
        }
        DataContainerUnit.register(this, treeMap.values());
        return true;
    }
}

