/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.gzip;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.gzip.OI;

public class GzipIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "gzip";

    public GzipIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Gzip archive handler", "Gzip file inflater", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!GzipIdentifier.checkBytes(iInput, 0, 31, -117)) {
            return false;
        }
        int n = GzipIdentifier.readHeaderByte(iInput, 2);
        if (n < 0 || n > 8) {
            return false;
        }
        int n2 = GzipIdentifier.readHeaderByte(iInput, 3);
        return n2 >= 0 && (n2 & 0xFFFFFFE0) == 0;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        OI oI = new OI(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return oI;
    }
}

