/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.corei.parsers.elf.of;
import java.nio.ByteBuffer;

public class ELFIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "elf";

    public ELFIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("ELF loader", "Linux Executable and Linkable Format (ELF) code object parser", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        return ELFIdentifier.checkBytes(iInput, 0, ELF.ElfMagic);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        of of2 = new of(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return of2;
    }

    public static boolean isELF64(IInput iInput) {
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() < 5) {
            throw new RuntimeException();
        }
        if (byteBuffer.getInt() != ELF.ElfMagicIntBE) {
            throw new RuntimeException();
        }
        byte by2 = byteBuffer.get();
        switch (by2) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        throw new RuntimeException("Unsupported ELF class");
    }
}

