/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.Ol;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.io.DirectByteArrayOutputStream;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jebglobal.AC;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.Yu;
import com.pnfsoftware.jebglobal.bX;
import com.pnfsoftware.jebglobal.xs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DecompileAll {
    private static final ILogger eO;
    private static final String Le = "--dump-all";
    private static final String Qx = "--dump-plaintext-ast";
    private static final String lS = "--dump-ser-ast";
    private static final String ae = "--max-routines";
    private static final String TI = "--max-routine-size";
    private static final String vT = "--unique-hash";
    private static final String KQ = "--unique-hash-db";
    private static String LZ;
    private static int XV;
    private static int lo;
    private static boolean qo;
    private static String kZ;
    private static Set<Yu> Kg;
    private static bX DA;

    public static void main(String[] stringArray) throws JebException, IOException {
        OI oI = DecompileAll.eO(stringArray);
        LZ = DecompileAll.Qx();
        int n = DecompileAll.eO(stringArray[0], stringArray[1], oI);
        if (kZ != null) {
            DecompileAll.Le();
        }
        eO.i("exiting with %d success", n);
        System.exit(n);
    }

    private static OI eO(String[] stringArray) {
        String string = String.format("Usage: <executable_file_path> <output_folder_path> %s|%s|%s [%s] [%s=int] [%s=int] [%s=path]", Le, Qx, lS, vT, TI, ae, KQ);
        Assert.a(stringArray.length >= 3, string);
        Assert.a(new File(stringArray[0]).isFile(), string);
        Assert.a(new File(stringArray[1]).isDirectory(), string);
        OI oI = DecompileAll.eO(stringArray[2]);
        Assert.a(oI != null, string);
        for (int j = 3; j < stringArray.length; ++j) {
            if (stringArray[j].startsWith(TI)) {
                XV = Integer.parseInt(stringArray[j].substring(TI.length() + 1));
            }
            if (stringArray[j].startsWith(ae)) {
                lo = Integer.parseInt(stringArray[j].substring(ae.length() + 1));
            }
            if (stringArray[j].equals(vT)) {
                qo = true;
            }
            if (!stringArray[j].startsWith(KQ)) continue;
            kZ = stringArray[j].substring(KQ.length() + 1);
            DecompileAll.eO();
        }
        return oI;
    }

    private static void eO() {
        File file = new File(kZ);
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                AC aC = AC.eO();
                SerializationManager serializationManager = new SerializationManager(aC);
                Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
                Kg = (Set)deserializer.deserialize();
            }
            catch (IOException iOException) {
                eO.error("File %s is not a valid unique hash set", file);
            }
        }
    }

    private static void Le() {
        DecompileAll.eO(new File(kZ), Kg);
    }

    private static OI eO(String string) {
        switch (string) {
            case "--dump-all": {
                return OI.eO;
            }
            case "--dump-plaintext-ast": {
                return OI.Le;
            }
            case "--dump-ser-ast": {
                return OI.Qx;
            }
        }
        return null;
    }

    private static String Qx() {
        String string = null;
        try {
            Process process = Runtime.getRuntime().exec("git log -1 --format=%ct_%h");
            process.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            eO.catching(exception);
        }
        return string;
    }

    private static int eO(String string, String string2, OI oI) throws JebException, IOException {
        Yo<?> yo = DecompileAll.Le(string);
        if (yo == null) {
            eO.error("cant get the native code unit", new Object[0]);
            return 0;
        }
        INativeDecompilerUnit iNativeDecompilerUnit = (INativeDecompilerUnit)DecompilerHelper.getDecompiler(yo);
        IPropertyManager iPropertyManager = iNativeDecompilerUnit.getPropertyManager();
        iPropertyManager.setBoolean("UseFriendlyVariableNames", true);
        iPropertyManager.setBoolean(UnitUtil.textProperty("MergeAdjacentDefinitions"), true);
        iPropertyManager.setBoolean("FailOnPipelineError", false);
        List<xs> list = yo.TI();
        int n = 0;
        int n2 = 0;
        for (xs xs2 : list) {
            eO.i("=> %d/%d: %s (%Xh)", ++n, list.size(), xs2.getName(true), xs2.KQ().getCFG().getEffectiveSize());
            if (qo && DecompileAll.eO(xs2, yo)) {
                eO.i("already decompiled hash", new Object[0]);
                continue;
            }
            if (XV != 0 && xs2.KQ().getCFG().getEffectiveSize() >= XV) {
                eO.error("too large: not decompiled", new Object[0]);
                continue;
            }
            if (lo != 0 && n2 >= lo) {
                eO.i("max routines reached, stopping here", new Object[0]);
                break;
            }
            INativeSourceUnit iNativeSourceUnit = DecompileAll.eO(xs2, iNativeDecompilerUnit);
            if (iNativeSourceUnit == null) {
                eO.error("decompilation failed", new Object[0]);
                continue;
            }
            ++n2;
            DecompileAll.eO(iNativeSourceUnit, string2, oI);
        }
        return n2;
    }

    private static void eO(INativeSourceUnit iNativeSourceUnit, String string, OI oI) {
        File file = new File(string + File.separator + LZ);
        if (!file.exists()) {
            file.mkdir();
        }
        String string2 = null;
        string2 = iNativeSourceUnit.getDecompilationTargets().size() == 1 ? iNativeSourceUnit.getDecompilationTargets().get(0).getRoutine().getName(false) : iNativeSourceUnit.getName();
        if (oI.eO()) {
            DecompileAll.eO(new File(file, string2 + ".c"), iNativeSourceUnit);
        }
        if (oI.Le()) {
            DecompileAll.Le(new File(file, string2 + ".ast.ser"), iNativeSourceUnit);
        }
    }

    private static void eO(File file, INativeSourceUnit iNativeSourceUnit) {
        ITextDocument iTextDocument = (ITextDocument)iNativeSourceUnit.getFormatter().getPresentation(0).getDocument();
        StringBuilder stringBuilder = TextDocumentUtil.buildText(iTextDocument);
        try {
            IO.writeFile(file, stringBuilder.toString());
        }
        catch (IOException iOException) {
            eO.error("error when writing file", new Object[0]);
        }
    }

    private static void Le(File file, INativeSourceUnit iNativeSourceUnit) {
        DecompileAll.eO(file, iNativeSourceUnit.getRootElement());
    }

    private static void eO(File file, Object object) {
        try (DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream();){
            AC aC = AC.eO();
            SerializationManager serializationManager = new SerializationManager(aC);
            Serializer serializer = serializationManager.getSerializer(directByteArrayOutputStream);
            serializer.serialize(object);
            serializer.close();
            IO.writeFile(file, directByteArrayOutputStream.getRawBytes(), 0, directByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            eO.error("ser error", new Object[0]);
        }
    }

    private static Yo<?> Le(String string) throws JebException, IOException {
        Ol ol2 = new Ol(new File(string).getParent(), new File(string).getName());
        List<IUnit> list = ol2.eO();
        if (list == null || list.isEmpty()) {
            eO.error("problem with root unit creation", new Object[0]);
            return null;
        }
        Yo yo = UnitUtil.findChildByType(list.get(0), Yo.class, false, 0);
        if (yo == null) {
            eO.error("cannot find PBCU", new Object[0]);
            return null;
        }
        if (!yo.process()) {
            eO.error("unit processing failed", new Object[0]);
            return null;
        }
        return yo;
    }

    private static INativeSourceUnit eO(xs xs2, INativeDecompilerUnit<?> iNativeDecompilerUnit) {
        INativeSourceUnit iNativeSourceUnit = null;
        try {
            GlobalLog.addGlobalFilter("", Integer.MAX_VALUE);
            iNativeSourceUnit = iNativeDecompilerUnit.decompile(xs2.getAddress());
            GlobalLog.removeGlobalFilter("");
        }
        catch (Exception exception) {
            GlobalLog.removeGlobalFilter("");
            eO.error("FAILED: %s: %s", exception.getClass().getName(), exception.getMessage());
            eO.catching(exception);
        }
        return iNativeSourceUnit;
    }

    private static boolean eO(xs xs2, Yo<?> yo) {
        if (Kg == null) {
            Kg = new HashSet<Yu>();
        }
        if (DA == null) {
            DA = new bX(yo.getProcessor());
        }
        DA.eO(xs2);
        Yu yu2 = (Yu)DA.eO().get(0);
        DA.Le();
        return !Kg.add(yu2);
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        eO = GlobalLog.getLogger(DecompileAll.class);
        LZ = null;
        XV = 0;
        lo = 0;
        kZ = null;
    }

    static enum OI {
        eO,
        Le,
        Qx;


        boolean eO() {
            return this == Le || this == eO;
        }

        boolean Le() {
            return this == Qx || this == eO;
        }
    }
}

