/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDecompilerPlugin;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CDocument;
import com.pnfsoftware.jebglobal.Qn;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.hd;

public class NativeDecompilerPseudoIdentifier
extends AbstractUnitIdentifier {
    private INativeDecompilerPlugin<?> nativeDecompilerPlugin;

    public NativeDecompilerPseudoIdentifier(INativeDecompilerPlugin<?> iNativeDecompilerPlugin) {
        super(iNativeDecompilerPlugin.getFormatType(), iNativeDecompilerPlugin.getPriority());
        this.nativeDecompilerPlugin = iNativeDecompilerPlugin;
    }

    public INativeDecompilerPlugin<?> getPlugin() {
        return this.nativeDecompilerPlugin;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return this.nativeDecompilerPlugin.getPluginInformation();
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition("UseSSAForm", PropertyTypeBoolean.create(false), "Let the decompiler convert intermediate form CFG to SSA forms");
        this.pdm.addDefinition("MemoryResolutionPolicy", PropertyTypeInteger.create(2), "A resolution policy guides the memory resolver in terms of what memory dereferences can be directly resolved. Supported policy values are:\n- 0: forbidden (no resolution allowed)\n- 1: allowed if reading takes place in read-only area, and points to a defined item\n- 2: #1 + allowed if reading takes place from \"special\" code object areas (eg, ELF's global offset table) and points to a defined item\n- 3: #1 + allowed if reading takes place from \"special\" code object areas (eg, ELF's global offset table)\n- 100: allowed from any area and points to a defined item\n- 200: allowed from any area");
        this.pdm.addDefinition("ReconversionMaxCount", PropertyTypeInteger.createPositiveOrZero(2), "Maximum decompilation pipeline restart (reconversion) allowed for a routine");
        this.pdm.addDefinition("IROptimizerMaxRunCount", PropertyTypeInteger.create(5), "Determine how many passes the IR optimizer may be allowed to run during an optimization task (0 means no limit)");
        this.pdm.addDefinition("IROptimizerDisableAggressivePass", PropertyTypeBoolean.create(), "Disable aggressive IR optimization pass, normally scheduled to run in later IR lifting stages. This pass is used to remove unused out-reaching variables.");
        this.pdm.addDefinition("ASTOptimizerMaxRunCount", PropertyTypeInteger.create(20), "Determine how many passes the AST optimizer may be allowed to run during an optimization task (0 means no limit)");
        this.pdm.addDefinition("FailOnPipelineError", PropertyTypeBoolean.create(Licensing.isDebugBuild()), "Determine whether or not an exception should be thrown on decompilation error. If not, the error will be visible as a comment in the decompiled code output");
        this.pdm.addDefinition("StructurerUseVersion", PropertyTypeInteger.create(0, 3, 2), "Version of the structurer to use (0 means use the default structuring algorithms - in release mode, default=newest)");
        this.pdm.addDefinition("UseFriendlyVariableNames", PropertyTypeBoolean.create(true), "Let the AST generate friendly identifier names (eg, based on types) instead of generic names");
        CDocument.buildPDM(this.pdm);
        this.nativeDecompilerPlugin.setupCustomProperties(this.pdm);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!(iUnitCreator instanceof Yo)) {
            return false;
        }
        String string = "dcmp_" + ((Yo)iUnitCreator).getFormatType();
        return string.equals(this.getFormatType());
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        Yo yo = (Yo)iUnitCreator;
        Qn qn2 = new Qn(this.getFormatType(), string, iUnitProcessor, yo, this.pdm);
        qn2.eO(this.nativeDecompilerPlugin.getConverter(yo));
        qn2.Le(this.nativeDecompilerPlugin.getPrimaryExtension(qn2));
        qn2.eO(this.nativeDecompilerPlugin.getGlobalAnalyzer(qn2));
        qn2.eO(this.nativeDecompilerPlugin.getSourceCustomizer(qn2));
        yo.addChildUnit(qn2);
        qn2.process();
        return qn2;
    }

    @Override
    public void setData(Object object, Object object2) {
        if (object instanceof String && ((String)object).equals("DGRM") && object2 instanceof Long) {
            try {
                long l2 = (Long)object2;
                if ((l2 & 0xFFFFFFFFFFFFFFF0L) == (Licensing.license_id & 0xFFFFFFFFFFFFFFF0L)) {
                    int n;
                    hd.Qx = n = ((int)l2 & 0xF) % 11;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setData(object, object2);
    }
}

