/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;
import java.util.List;

public class DebuggerUtil {
    private static final ILogger logger = GlobalLog.getLogger(DebuggerUtil.class);

    public static byte[] readMemoryStringSafe(IDebuggerUnit iDebuggerUnit, long l2, int n) {
        return DebuggerUtil.readMemorySafe(iDebuggerUnit, l2, n);
    }

    public static byte[] readMemorySafe(IDebuggerUnit iDebuggerUnit, long l2, int n) {
        byte[] byArray = new byte[n];
        try {
            int n2 = DebuggerUtil.readMemory(iDebuggerUnit, l2, n, byArray);
            if (n2 < 0) {
                logger.error("Unable to read memory at %Xh (%d)", l2, n2);
                return null;
            }
            return n2 < n ? Arrays.copyOf(byArray, n2) : byArray;
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return null;
        }
    }

    private static int readMemory(IDebuggerUnit iDebuggerUnit, long l2, int n, byte[] byArray) {
        return iDebuggerUnit.readMemory(l2, n, byArray, 0);
    }

    public static ICodeUnit getPotentialDebuggee(IDebuggerUnit iDebuggerUnit, long l2) {
        List<? extends ICodeUnit> list = iDebuggerUnit.getPotentialDebuggees();
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        for (ICodeUnit iCodeUnit : iDebuggerUnit.getPotentialDebuggees()) {
            if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
            INativeCodeUnit iNativeCodeUnit = (INativeCodeUnit)iCodeUnit;
            long l3 = iNativeCodeUnit.getVirtualImageBase() + iNativeCodeUnit.getPhysicalImageDelta();
            long l4 = l3 + iNativeCodeUnit.getImageSize();
            if (l3 > l2 || l2 >= l4) continue;
            return iCodeUnit;
        }
        return null;
    }

    public static boolean isNativeCodeDebugger(IDebuggerUnit iDebuggerUnit) {
        for (ICodeUnit iCodeUnit : iDebuggerUnit.getPotentialDebuggees()) {
            if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
            return true;
        }
        return false;
    }
}

