/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.IAliasType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.util.format.Strings;

public class PrettyTypeFormatter {
    INativeType type;
    StringBuilder sb;
    int levelInnerFormatting;
    boolean offsetsAsComments;

    public PrettyTypeFormatter(INativeType iNativeType) {
        if (iNativeType == null) {
            throw new NullPointerException();
        }
        this.type = iNativeType;
    }

    public String format() {
        return this.format(1, false);
    }

    public String format(int n, boolean bl2) {
        this.levelInnerFormatting = n;
        this.offsetsAsComments = bl2;
        this.sb = new StringBuilder();
        this.gen(this.type, 0, 0);
        this.sb.append(';');
        if (bl2) {
            this.sb.append(String.format("  // %Xh", this.type.getSize()));
        }
        this.sb.append('\n');
        return this.sb.toString();
    }

    private void gen(INativeType iNativeType, int n, int n2) {
        if (n < this.levelInnerFormatting) {
            if (iNativeType instanceof IArrayType) {
                IArrayType iArrayType = (IArrayType)iNativeType;
                this.gen(iArrayType.getElementType(), n, n2);
                this.sb.append(String.format("[%d]", iArrayType.getElementCount()));
            } else if (iNativeType instanceof IReferenceType) {
                IReferenceType iReferenceType = (IReferenceType)iNativeType;
                this.indentAppend(iReferenceType.getMainType().getName(true), n);
                this.sb.append(Strings.generate('*', iReferenceType.getReferenceCount()));
            } else if (iNativeType instanceof IAliasType) {
                IAliasType iAliasType = (IAliasType)iNativeType;
                INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
                if (iNativeType2 instanceof IStructureType) {
                    this.indentAppend(String.format("/* %s */\n", iAliasType.getName(true)), n);
                    this.gen(iNativeType2, n, n2);
                } else {
                    this.indentAppend(iAliasType.getName(true), n);
                }
            } else if (iNativeType instanceof IStructureType) {
                IStructureType iStructureType = (IStructureType)iNativeType;
                if (iStructureType.getPadding() > 1 || iStructureType.getAlignment() > 1) {
                    this.sb.append(String.format("/*pack:%d,align:%d*/ ", iStructureType.getPadding(), iStructureType.getAlignment()));
                }
                this.indentAppend(iStructureType.isUnion() ? "union" : "struct", n);
                this.sb.append(String.format(" %s {\n", iStructureType.getName(true)));
                for (IStructureTypeField iStructureTypeField : iStructureType.getFieldsWithGaps()) {
                    INativeType iNativeType3 = iStructureTypeField.getType();
                    this.gen(iNativeType3, n + 1, n2 + iStructureTypeField.getOffset());
                    if (iStructureTypeField.getAlignment() > 1) {
                        this.sb.append(String.format(" /*alignas(%d)*/", iStructureTypeField.getAlignment()));
                    }
                    if (iNativeType3 != null) {
                        this.sb.append(String.format(" %s;", iStructureTypeField.getName(true)));
                    }
                    if (this.offsetsAsComments) {
                        this.sb.append(String.format("  // %Xh", n2 + iStructureTypeField.getOffset()));
                    }
                    this.sb.append('\n');
                }
                this.indentAppend("}", n);
            } else {
                this.indentAppend(iNativeType == null ? "/*padding*/" : iNativeType.getName(true), n);
            }
        } else {
            this.indentAppend(iNativeType == null ? "/*padding*/" : iNativeType.getName(true), n);
        }
    }

    private void indentAppend(String string, int n) {
        this.sb.append(Strings.generate(' ', n * 2));
        this.sb.append(string);
    }
}

