/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICompiler;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.LibraryID;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeItemListener;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeFeature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.INativeSignature;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeFeatureSignerID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureMatchResult;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignaturePackageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignaturePackageMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.sig.NativeSignatureScopeException;
import com.pnfsoftware.jeb.core.units.code.asm.sig.SignatureTargetType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.io.DirectByteArrayOutputStream;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jebglobal.AC;
import com.pnfsoftware.jebglobal.He;
import com.pnfsoftware.jebglobal.Iz;
import com.pnfsoftware.jebglobal.NK;
import com.pnfsoftware.jebglobal.RJ;
import com.pnfsoftware.jebglobal.Xc;
import com.pnfsoftware.jebglobal.Yu;
import com.pnfsoftware.jebglobal.bJ;
import com.pnfsoftware.jebglobal.sI;
import com.pnfsoftware.jebglobal.sy;
import com.pnfsoftware.jebglobal.xs;
import com.pnfsoftware.jebglobal.yX;
import com.pnfsoftware.jebglobal.zo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeSignatureDBManager
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(NativeSignatureDBManager.class);
    public static final String AUTOLOAD_PACKAGES_PROPERTY = "SiglibsAutoLoadPackages";
    public static final String SIGLIB_EXTENSION = ".siglib";
    public static final String SIGLIB_USER_PACKAGE_FOLDER = "custom";
    private static NativeSignatureDBManager instance;
    private final IEnginesContext enginesContext;
    private final NativeSignatureGenerator signatureGenerator;
    private Set<File> folders = new HashSet<File>();
    private File userCreatedPackageFolder;
    private List<NativeSignaturePackageEntry> entries = new ArrayList<NativeSignaturePackageEntry>();
    private boolean isActive = true;
    private boolean autoLoadSuitablePackages = true;
    private Map<Integer, NativeSignaturePackageEntry> idEntryMap = new HashMap<Integer, NativeSignaturePackageEntry>();
    private Map<INativeCodeAnalyzer<IInstruction>, SignatureMemoryStorage> memoryStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, SignatureMemoryStorage>();
    private Map<INativeCodeAnalyzer<IInstruction>, NativeSignaturePackageEntry> userSelectedPackageStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, NativeSignaturePackageEntry>();
    private Map<INativeCodeAnalyzer<IInstruction>, bJ> autoModeManagerStorage = new HashMap<INativeCodeAnalyzer<IInstruction>, bJ>();

    public static NativeSignatureDBManager getInstance(IEnginesContext iEnginesContext) {
        if (instance == null) {
            instance = new NativeSignatureDBManager(iEnginesContext);
        }
        return instance;
    }

    private NativeSignatureDBManager(IEnginesContext iEnginesContext) {
        this.signatureGenerator = NativeSignatureGenerator.getInstance(new sI());
        this.enginesContext = iEnginesContext;
        this.enginesContext.addListener(this);
        this.autoLoadSuitablePackages = iEnginesContext.getPropertyManager().getBoolean(AUTOLOAD_PACKAGES_PROPERTY);
    }

    public void addFolder(File file, boolean bl2) {
        this.folders.add(file);
        if (file.getName().equals(SIGLIB_USER_PACKAGE_FOLDER)) {
            this.userCreatedPackageFolder = file;
        }
        if (bl2) {
            this.rescan();
        }
    }

    public void removeFolder(File file, boolean bl2) {
        this.folders.remove(file);
        if (bl2) {
            this.rescan();
        }
    }

    public void removeAllFolders() {
        this.folders.clear();
    }

    public synchronized void rescan() {
        this.rescan(true);
    }

    /*
     * Could not resolve type clashes
     */
    public synchronized void rescan(boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object object : this.entries) {
            ((NativeSignaturePackageEntry)object).setStatus(NativeSignaturePackageEntry.PackageStatus.INACTIVE);
        }
        for (Object object : this.folders) {
            if (object == null || !((File)object).exists() || !((File)object).isDirectory()) {
                logger.warn("Native signature folder is invalid: %s", object);
                continue;
            }
            for (File file : ((File)object).listFiles()) {
                NativeSignaturePackageMetadata nativeSignaturePackageMetadata;
                Object object2;
                Object object3;
                if (!file.isFile() || !file.getName().endsWith(SIGLIB_EXTENSION)) continue;
                try {
                    object3 = new FileInputStream(file);
                    Object object4 = null;
                    try {
                        Object object5 = AC.eO();
                        object2 = new SerializationManager((ITypeIdProvider)object5);
                        Deserializer deserializer = ((SerializationManager)object2).getDeserializer((InputStream)object3);
                        nativeSignaturePackageMetadata = (NativeSignaturePackageMetadata)deserializer.deserialize();
                    }
                    catch (Throwable throwable) {
                        object4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object3 != null) {
                            if (object4 != null) {
                                try {
                                    ((FileInputStream)object3).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object4).addSuppressed(throwable);
                                }
                            } else {
                                ((FileInputStream)object3).close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error("Error when opening native signature package %s", file);
                    NativeSignatureDBManager.collectInformationDeserFailure(file, "metadata");
                    continue;
                }
                object3 = null;
                for (Object object5 : this.entries) {
                    if (!((NativeSignaturePackageEntry)object5).getFile().equals(file)) continue;
                    object3 = object5;
                    break;
                }
                if (object3 != null) {
                    ((NativeSignaturePackageEntry)object3).setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
                    continue;
                }
                boolean bl3 = true;
                int n = nativeSignaturePackageMetadata.getUuid();
                if (n == 0) {
                    arrayList.add(file);
                    bl3 = false;
                } else if (n > 0 && (object2 = this.idEntryMap.get(n)) != null) {
                    int n2;
                    int n3 = ((NativeSignaturePackageEntry)object2).getMetadata().getVersion();
                    if (n3 > (n2 = nativeSignaturePackageMetadata.getVersion())) {
                        arrayList.add(file);
                        bl3 = false;
                    } else if (n3 < n2) {
                        arrayList.add(((NativeSignaturePackageEntry)object2).getFile());
                        this.entries.remove(object2);
                    } else {
                        logger.warn("Two siglib entries have the same UUID and version number: uuid=%d (files: %s and %s)", n, file, ((NativeSignaturePackageEntry)object2).getFile());
                    }
                }
                if (!bl3) continue;
                object3 = new NativeSignaturePackageEntry(file, nativeSignaturePackageMetadata);
                ((NativeSignaturePackageEntry)object3).setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
                this.entries.add((NativeSignaturePackageEntry)object3);
                if (n <= 0) continue;
                this.idEntryMap.put(n, (NativeSignaturePackageEntry)object3);
            }
        }
        if (bl2) {
            for (Object object : arrayList) {
                ((File)object).delete();
            }
        }
        int n = 0;
        while (n < this.entries.size()) {
            Object object;
            object = this.entries.get(n);
            if (((NativeSignaturePackageEntry)object).getStatus() == NativeSignaturePackageEntry.PackageStatus.INACTIVE) {
                this.entries.remove(n);
                continue;
            }
            ++n;
        }
    }

    private static void collectInformationDeserFailure(File file, String string) {
        String string2 = "";
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            HashCalculator hashCalculator = new HashCalculator(fileInputStream, 16);
            if (hashCalculator.compute()) {
                string2 = Formatter.byteArrayToHexString(hashCalculator.getSha256());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JebCoreService.notifySilentExceptionToClient(new SerializationException(String.format("Signature package deser failed (msg:%s - fileName:%s - sha256:%s - lastModified:%d)", string, file.getName(), string2, file.lastModified())));
    }

    public List<NativeSignaturePackageEntry> getAvailablePackages() {
        return this.entries;
    }

    public void removeAllPackages() {
        this.entries.clear();
        this.idEntryMap.clear();
    }

    public List<NativeSignaturePackageEntry> getLoadedPackages() {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isLoadedInMemory()) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public List<NativeSignaturePackageEntry> getUserCreatedPackages(ProcessorType processorType) {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated() || !nativeSignaturePackageEntry.getMetadata().getTargetProcessorType().equals((Object)processorType)) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public List<NativeSignaturePackageEntry> getUserCreatedPackages() {
        ArrayList<NativeSignaturePackageEntry> arrayList = new ArrayList<NativeSignaturePackageEntry>();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated()) continue;
            arrayList.add(nativeSignaturePackageEntry);
        }
        return arrayList;
    }

    public void updateOnDiskPackages(boolean bl2) {
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.entries) {
            Object object;
            NK nK;
            NativeSignaturePackageMetadata nativeSignaturePackageMetadata;
            List<INativeSignature> list;
            block25: {
                if (!nativeSignaturePackageEntry.isActive() || !nativeSignaturePackageEntry.isUserCreated() || (list = nativeSignaturePackageEntry.getSignatureToWrite()) == null || list.isEmpty()) continue;
                nativeSignaturePackageMetadata = null;
                nK = null;
                try {
                    Iterator<INativeSignature> iterator = new FileInputStream(nativeSignaturePackageEntry.getFile());
                    Throwable throwable = null;
                    try {
                        object = AC.eO();
                        SerializationManager serializationManager = new SerializationManager((ITypeIdProvider)object);
                        Deserializer deserializer = serializationManager.getDeserializer((InputStream)((Object)iterator));
                        nativeSignaturePackageMetadata = (NativeSignaturePackageMetadata)deserializer.deserialize();
                        if (nativeSignaturePackageMetadata == null || (nK = (NK)deserializer.deserialize()) == null) {
                            continue;
                        }
                        break block25;
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iterator == null) continue;
                        if (throwable != null) {
                            try {
                                ((FileInputStream)((Object)iterator)).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((FileInputStream)((Object)iterator)).close();
                    }
                }
                catch (Exception exception) {
                    logger.error("Error when opening native signature package %s", nativeSignaturePackageEntry.getFile());
                    NativeSignatureDBManager.collectInformationDeserFailure(nativeSignaturePackageEntry.getFile(), "update on disk");
                }
                continue;
            }
            if (!bl2) {
                for (INativeSignature iNativeSignature : list) {
                    nK.eO(iNativeSignature);
                }
            } else {
                for (INativeSignature iNativeSignature : list) {
                    object = null;
                    for (INativeSignature iNativeSignature2 : nK.getSignatures()) {
                        if (!iNativeSignature2.matchExactly(iNativeSignature)) continue;
                        object = iNativeSignature2;
                        break;
                    }
                    if (object != null) {
                        nK.getSignatures().remove(object);
                    }
                    nK.eO(iNativeSignature);
                }
            }
            this.writePackageOnDisk(nativeSignaturePackageEntry.getFile(), nativeSignaturePackageMetadata, nK);
            nativeSignaturePackageEntry.clearSignaturesToWrite();
        }
    }

    public NativeSignaturePackageEntry createUserPackage(ProcessorType processorType, String string, String string2, String string3) {
        if (this.userCreatedPackageFolder == null) {
            logger.error("user folder is not set", new Object[0]);
            return null;
        }
        return this.createPackageInternal(this.userCreatedPackageFolder, processorType, string, -1, 0, string2, string3, null, null);
    }

    private NativeSignaturePackageEntry createPackageInternal(File file, ProcessorType processorType, String string, int n, int n2, String string2, String string3, ICompiler iCompiler, LibraryID libraryID) {
        File file2 = new File(file, string + SIGLIB_EXTENSION);
        if (file2.exists()) {
            return null;
        }
        NativeSignaturePackageMetadata nativeSignaturePackageMetadata = NativeSignaturePackageMetadata.create(processorType, string, n, n2, string2, string3, iCompiler, libraryID);
        NK nK = new NK(nativeSignaturePackageMetadata);
        this.writePackageOnDisk(file2, nativeSignaturePackageMetadata, nK);
        NativeSignaturePackageEntry nativeSignaturePackageEntry = new NativeSignaturePackageEntry(file2, nativeSignaturePackageMetadata);
        nativeSignaturePackageEntry.setStatus(NativeSignaturePackageEntry.PackageStatus.ACTIVE);
        this.entries.add(nativeSignaturePackageEntry);
        return nativeSignaturePackageEntry;
    }

    private boolean writePackageOnDisk(File file, NativeSignaturePackageMetadata nativeSignaturePackageMetadata, NK nK) {
        try (DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream();){
            AC aC = AC.eO();
            SerializationManager serializationManager = new SerializationManager(aC);
            Serializer serializer = serializationManager.getSerializer(directByteArrayOutputStream);
            serializer.serialize(nativeSignaturePackageMetadata);
            serializer.serialize(nK);
            serializer.close();
            IO.writeFile(file, directByteArrayOutputStream.getRawBytes(), 0, directByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        return true;
    }

    public void loadPackages(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        if (!this.autoLoadSuitablePackages) {
            return;
        }
        ProcessorType processorType = iNativeCodeAnalyzer.getProcessor().getType();
        ICompiler iCompiler = iNativeCodeAnalyzer.getDetectedCompiler();
        for (NativeSignaturePackageEntry nativeSignaturePackageEntry : this.getAvailablePackages()) {
            SignatureMemoryStorage signatureMemoryStorage;
            ICompiler iCompiler2;
            if (!nativeSignaturePackageEntry.getMetadata().getTargetProcessorType().equals((Object)processorType) || nativeSignaturePackageEntry.isUserCreated() || (iCompiler2 = nativeSignaturePackageEntry.getMetadata().getTargetCompiler()) != null && (iCompiler == null || !iCompiler.getClass().equals(iCompiler2.getClass())) || (signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer)) != null && signatureMemoryStorage.loadedPackages != null && signatureMemoryStorage.loadedPackages.contains(nativeSignaturePackageEntry)) continue;
            this.loadPackage(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
        }
    }

    public boolean loadPackage(NativeSignaturePackageEntry nativeSignaturePackageEntry, boolean bl2) {
        boolean bl3 = false;
        for (INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer : this.memoryStorage.keySet()) {
            ACLock aCLock = ((Xc)iNativeCodeAnalyzer).XV().Le().a();
            Throwable throwable = null;
            try {
                if (!iNativeCodeAnalyzer.getProcessor().getType().equals((Object)nativeSignaturePackageEntry.getMetadata().getTargetProcessorType()) || !this.loadInternal(iNativeCodeAnalyzer, nativeSignaturePackageEntry)) continue;
                if (bl2) {
                    ((Xc)iNativeCodeAnalyzer).kZ();
                }
                bl3 = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (aCLock == null) continue;
                if (throwable != null) {
                    try {
                        aCLock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                aCLock.close();
            }
        }
        return bl3;
    }

    public boolean loadPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        return this.loadInternal(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
    }

    private synchronized boolean loadInternal(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            logger.error("unknown analyzer", new Object[0]);
            return false;
        }
        return signatureMemoryStorage.loadPackage(nativeSignaturePackageEntry);
    }

    public void activateAutoSigningMode(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        Assert.a(this.getUserSelectedPackage(iNativeCodeAnalyzer) != null);
        bJ bJ2 = this.autoModeManagerStorage.get(iNativeCodeAnalyzer);
        if (bJ2 == null) {
            int n = 0;
            if (this.enginesContext != null) {
                n = this.enginesContext.getPropertyManager().getInteger("SiglibsAutoModeSaveCount");
            }
            bJ2 = new zo(iNativeCodeAnalyzer, this, n);
            iNativeCodeAnalyzer.getModel().addListener(bJ2);
            ((sy)iNativeCodeAnalyzer.getTypeManager()).eO((INativeItemListener)bJ2);
            this.autoModeManagerStorage.put(iNativeCodeAnalyzer, bJ2);
        }
    }

    public void deactivateAutoSigningMode(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        bJ bJ2 = this.autoModeManagerStorage.remove(iNativeCodeAnalyzer);
        if (bJ2 != null) {
            iNativeCodeAnalyzer.getModel().removeListener(bJ2);
            ((sy)iNativeCodeAnalyzer.getTypeManager()).Le(bJ2);
        }
    }

    public boolean isAutoSigningModeActivated(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        return this.autoModeManagerStorage.containsKey(iNativeCodeAnalyzer);
    }

    public void registerAnalyzer(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            signatureMemoryStorage = new SignatureMemoryStorage(iNativeCodeAnalyzer);
            this.memoryStorage.put(iNativeCodeAnalyzer, signatureMemoryStorage);
        }
    }

    public void unregisterAnalyzer(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.remove(iNativeCodeAnalyzer);
        if (signatureMemoryStorage != null && signatureMemoryStorage.loadedPackages != null) {
            for (NativeSignaturePackageEntry nativeSignaturePackageEntry : signatureMemoryStorage.loadedPackages) {
                nativeSignaturePackageEntry.decrementOpenHandle();
            }
        }
        this.userSelectedPackageStorage.remove(iNativeCodeAnalyzer);
        this.deactivateAutoSigningMode(iNativeCodeAnalyzer);
    }

    public int getNumberLoadedSigs() {
        int n = 0;
        for (SignatureMemoryStorage signatureMemoryStorage : this.memoryStorage.values()) {
            for (Map map : signatureMemoryStorage.signaturesDB.values()) {
                n += map.size();
            }
        }
        return n;
    }

    private static int getRoutineSize(INativeSignature iNativeSignature) {
        int n = 0;
        for (INativeFeature iNativeFeature : ((He)iNativeSignature).eO()) {
            if (!(iNativeFeature instanceof yX)) continue;
            n = ((yX)iNativeFeature).eO();
            break;
        }
        return n;
    }

    private static Yu getRoutineCodeHash(INativeSignature iNativeSignature) {
        Yu yu2 = null;
        for (INativeFeature iNativeFeature : ((He)iNativeSignature).eO()) {
            if (!(iNativeFeature instanceof Yu)) continue;
            yu2 = (Yu)iNativeFeature;
            break;
        }
        return yu2;
    }

    public void setActive(boolean bl2) {
        this.isActive = bl2;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private NativeSignatureMatchResult internalMatch(SignatureMemoryStorage signatureMemoryStorage, xs xs2, boolean bl2, boolean bl3) throws NativeSignatureScopeException {
        Object object;
        if (signatureMemoryStorage == null) {
            List<INativeSignature> list = Collections.emptyList();
            return new NativeSignatureMatchResult(xs2, list, true, INativeSignature.ConfidenceLevel.UNKNOWN);
        }
        int n = xs2.KQ().getCFG().getInstructionCount();
        Set set = (Set)signatureMemoryStorage.routineSignersDB.get(n);
        Map map = (Map)signatureMemoryStorage.signaturesDB.get(n);
        if (map == null || set == null) {
            List<INativeSignature> list = Collections.emptyList();
            return new NativeSignatureMatchResult(xs2, list, true, INativeSignature.ConfidenceLevel.UNKNOWN);
        }
        ArrayList<INativeFeature> arrayList = new ArrayList<INativeFeature>();
        for (NativeFeatureSignerID nativeFeatureSignerID : set) {
            object = (RJ)signatureMemoryStorage.signersDB.get((Object)nativeFeatureSignerID);
            ((RJ)object).eO(xs2);
            arrayList.addAll(((RJ)object).eO());
            ((RJ)object).Le();
        }
        ArrayList arrayList2 = new ArrayList();
        boolean bl4 = true;
        object = INativeSignature.ConfidenceLevel.LOW;
        for (INativeSignature iNativeSignature : map.keySet()) {
            if (iNativeSignature.getFlags().getTargetType() != SignatureTargetType.ROUTINE || !((He)iNativeSignature).Qx(arrayList)) continue;
            if (bl3) {
                INativeSignature.ConfidenceLevel confidenceLevel = iNativeSignature.getConfidenceLevel();
                if (confidenceLevel == null || confidenceLevel.compareTo(object) < 0) continue;
                if (confidenceLevel.compareTo(object) == 0) {
                    arrayList2.add(iNativeSignature);
                } else {
                    object = confidenceLevel;
                    arrayList2.clear();
                    arrayList2.add(iNativeSignature);
                }
            } else {
                arrayList2.add(iNativeSignature);
            }
            if (arrayList2.size() < 2 || !bl2) continue;
            bl4 = false;
            break;
        }
        NativeSignatureMatchResult nativeSignatureMatchResult = new NativeSignatureMatchResult(xs2, arrayList2, bl4, (INativeSignature.ConfidenceLevel)((Object)(bl3 ? object : INativeSignature.ConfidenceLevel.UNKNOWN)));
        return nativeSignatureMatchResult;
    }

    public List<NativeSignatureMatchResult> match(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, Collection<INativeMethodDataItem> collection, boolean bl2, boolean bl3, boolean bl4) {
        ((Xc)iNativeCodeAnalyzer).XV().Le().verifyLocked();
        List<NativeSignatureMatchResult> list = Collections.emptyList();
        if (!this.isActive || collection.isEmpty()) {
            return list;
        }
        SignatureMemoryStorage signatureMemoryStorage = this.memoryStorage.get(iNativeCodeAnalyzer);
        if (signatureMemoryStorage == null) {
            return list;
        }
        list = new ArrayList<NativeSignatureMatchResult>();
        for (INativeMethodDataItem iNativeMethodDataItem : collection) {
            xs xs2 = (xs)iNativeMethodDataItem.getRoutine();
            if (!this.canBeMatched(xs2, bl4)) continue;
            try {
                NativeSignatureMatchResult nativeSignatureMatchResult = this.internalMatch(signatureMemoryStorage, xs2, bl2, bl3);
                list.add(nativeSignatureMatchResult);
            }
            catch (NativeSignatureScopeException nativeSignatureScopeException) {
                logger.i("Problem during feature computation", new Object[0]);
            }
        }
        return list;
    }

    private boolean canBeMatched(xs xs2, boolean bl2) {
        if (xs2 == null) {
            return false;
        }
        if (xs2.AP()) {
            return false;
        }
        if (xs2.KQ() == null) {
            return false;
        }
        return bl2 || xs2.BQ() == null;
    }

    public NativeSignatureGenerator getSignatureGenerator() {
        return this.signatureGenerator;
    }

    public File getUserCreatedPackageFolder() {
        return this.userCreatedPackageFolder;
    }

    public NativeSignaturePackageEntry getUserSelectedPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
        return this.userSelectedPackageStorage.get(iNativeCodeAnalyzer);
    }

    public void setUserSelectedPackage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer, NativeSignaturePackageEntry nativeSignaturePackageEntry) {
        this.userSelectedPackageStorage.put(iNativeCodeAnalyzer, nativeSignaturePackageEntry);
    }

    @Override
    public void onEvent(IEvent iEvent) {
        if (iEvent.getType() == J.ProjectSaved) {
            this.updateOnDiskPackages(true);
        }
    }

    private static class SignatureMemoryStorage {
        private List<NativeSignaturePackageEntry> loadedPackages = new ArrayList<NativeSignaturePackageEntry>();
        private Map<Integer, Map<INativeSignature, INativeSignature>> signaturesDB = new HashMap<Integer, Map<INativeSignature, INativeSignature>>();
        private Map<NativeFeatureSignerID, RJ<IInstruction>> signersDB;
        private Map<Integer, Set<NativeFeatureSignerID>> routineSignersDB;

        public SignatureMemoryStorage(INativeCodeAnalyzer<IInstruction> iNativeCodeAnalyzer) {
            this.signersDB = Iz.eO((Xc)iNativeCodeAnalyzer);
            this.routineSignersDB = new HashMap<Integer, Set<NativeFeatureSignerID>>();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean loadPackage(NativeSignaturePackageEntry nativeSignaturePackageEntry) {
            try (FileInputStream fileInputStream = new FileInputStream(nativeSignaturePackageEntry.getFile());){
                AC aC = AC.eO();
                SerializationManager serializationManager = new SerializationManager(aC);
                Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
                deserializer.deserialize();
                NK nK = (NK)deserializer.deserialize();
                for (INativeSignature iNativeSignature : nK.getSignatures()) {
                    INativeSignature iNativeSignature2;
                    int n = NativeSignatureDBManager.getRoutineSize(iNativeSignature);
                    if (n == 0) {
                        logger.i("Cannot load signature %s -- missing routine size", iNativeSignature);
                        continue;
                    }
                    Map<INativeSignature, INativeSignature> map = this.signaturesDB.get(n);
                    if (map == null) {
                        map = new HashMap<INativeSignature, INativeSignature>();
                        this.signaturesDB.put(n, map);
                    }
                    if ((iNativeSignature2 = map.get(iNativeSignature)) != null) {
                        ((He)iNativeSignature2).eO(nativeSignaturePackageEntry);
                    } else {
                        ((He)iNativeSignature).eO(nativeSignaturePackageEntry);
                        map.put(iNativeSignature, iNativeSignature);
                    }
                    Set<NativeFeatureSignerID> set = this.routineSignersDB.get(n);
                    if (set == null) {
                        set = new HashSet<NativeFeatureSignerID>();
                        this.routineSignersDB.put(n, set);
                    }
                    for (INativeFeature iNativeFeature : ((He)iNativeSignature).eO()) {
                        NativeFeatureSignerID nativeFeatureSignerID = Iz.eO(iNativeFeature);
                        set.add(nativeFeatureSignerID);
                    }
                }
                nativeSignaturePackageEntry.incrementOpenHandle();
                this.loadedPackages.add(nativeSignaturePackageEntry);
                boolean bl2 = true;
                return bl2;
            }
            catch (Exception exception) {
                logger.error("Error when opening native signature package %s", nativeSignaturePackageEntry.getFile());
                NativeSignatureDBManager.collectInformationDeserFailure(nativeSignaturePackageEntry.getFile(), "package loading");
                return false;
            }
        }
    }
}

