/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IOperandBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.IEncodedMemoryArea;

public abstract class AbstractOperandBuilder<T extends IInstructionOperand>
implements IOperandBuilder<T> {
    public static final int OPTIONAL_DEFAULT_VALUE = 0;
    public static final int OPTIONAL_MASK = 0;
    public static final int NO_FLAG = 0;
    public static final int OPTIONAL = 0x10000000;
    private IEncodedMemoryArea memoryArea;
    protected int flags;
    private int defaultValue;
    private int defaultValueMask;

    public AbstractOperandBuilder(IEncodedMemoryArea iEncodedMemoryArea) {
        this(iEncodedMemoryArea, 0, 0, 0);
    }

    public AbstractOperandBuilder(IEncodedMemoryArea iEncodedMemoryArea, int n) {
        this(iEncodedMemoryArea, n, 0, 0);
    }

    public AbstractOperandBuilder(IEncodedMemoryArea iEncodedMemoryArea, int n, int n2, int n3) {
        this.memoryArea = iEncodedMemoryArea;
        this.flags = n;
        this.defaultValue = n2;
        this.defaultValueMask = n3;
    }

    public boolean isOptional(long l2) {
        return (this.flags & 0x10000000) != 0 && (this.defaultValueMask == 0 && l2 == (long)this.defaultValue || this.defaultValueMask != 0 && (l2 & (long)this.defaultValueMask) == (long)this.defaultValue);
    }

    public int getFlags() {
        return this.flags;
    }

    protected IEncodedMemoryArea getMemoryArea() {
        return this.memoryArea;
    }

    protected int decodeMemoryArea(byte[] byArray) {
        return this.memoryArea.decodeInt(byArray);
    }
}

