/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.util.collect.CFBytesTrie;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.List;

@SerDisabled
public abstract class AbstractInstructionManager<T extends IInstruction>
implements CFBytesTrie.IKeyExtractor<T> {
    private long instructionCount = 0L;
    private long uniqueInstructionCount = 0L;
    private CFBytesTrie<T> insnCacheFast;
    private List<ProcessorException> exceptions = new ArrayList<ProcessorException>();

    public AbstractInstructionManager() {
        this.insnCacheFast = new CFBytesTrie();
        this.insnCacheFast.setKeyExtractor(this);
    }

    public T getInstruction(BytesBlock bytesBlock) throws ProcessorException {
        boolean bl2 = this.useCache(bytesBlock);
        byte[] byArray = this.buildKey(bytesBlock);
        IInstruction iInstruction = null;
        if (bl2 && (iInstruction = (IInstruction)this.insnCacheFast.get(byArray, false)) != null) {
            ++this.instructionCount;
            return (T)this.retrieveInstructionFromCache(iInstruction);
        }
        try {
            iInstruction = (IInstruction)this.findInstruction(bytesBlock);
            if (iInstruction != null && bl2) {
                this.insnCacheFast.put(byArray, iInstruction);
            }
            ++this.uniqueInstructionCount;
            ++this.instructionCount;
            return (T)iInstruction;
        }
        catch (ProcessorException processorException) {
            this.exceptions.add(processorException);
            throw processorException;
        }
    }

    protected T retrieveInstructionFromCache(T t) {
        return t;
    }

    protected abstract T findInstruction(BytesBlock var1) throws ProcessorException;

    protected boolean useCache(BytesBlock bytesBlock) throws ProcessorException {
        return true;
    }

    protected byte[] buildKey(BytesBlock bytesBlock) throws ProcessorException {
        return bytesBlock.getCode();
    }

    protected static void raiseUndefined(byte[] byArray) throws ProcessorException {
        throw new ProcessorException(AbstractInstructionManager.getUndefinedMessage(byArray));
    }

    protected static String getUndefinedMessage(byte[] byArray) {
        return Strings.f("Instruction %s is undefined", Formatter.byteArrayToHexString(byArray));
    }

    protected static String getUnpredictableMessage(byte[] byArray, String string) {
        return Strings.f("Instruction %s %s is unpredictable", Formatter.byteArrayToHexString(byArray), string);
    }

    public long getInstructionCount() {
        return this.instructionCount;
    }

    public long getUniqueInstructionCount() {
        return this.uniqueInstructionCount;
    }

    public List<ProcessorException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public byte[] extract(T t) {
        return t.getCode();
    }
}

