/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.mangling;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IManglingEngine;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IUnmangledData;
import com.pnfsoftware.jeb.core.units.code.asm.mangling.IUnmangledRoutine;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.AY;
import com.pnfsoftware.jebglobal.QS;
import com.pnfsoftware.jebglobal.Qn;
import com.pnfsoftware.jebglobal.YI;
import com.pnfsoftware.jebglobal.pZ;
import com.pnfsoftware.jebglobal.xs;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UnmanglerService {
    private static final ILogger logger = GlobalLog.getLogger(UnmanglerService.class);
    public static final int MANGLING_ENGINE_MSVC = 1;
    public static final int MANGLING_ENGINE_MSVCPP = 2;
    public static final int MANGLING_ENGINE_MSVCPP_V2 = 3;
    public static final int MANGLING_ENGINE_CXXA = 4;
    private List<IManglingEngine> engines = new CopyOnWriteArrayList<IManglingEngine>();
    private INativeCodeUnit<?> codeUnit;
    private List<Qn> decompilers;

    public UnmanglerService(INativeCodeUnit<?> iNativeCodeUnit) {
        this.codeUnit = iNativeCodeUnit;
    }

    public void registerEngine(int n) {
        if (n == 1) {
            this.engines.add(new AY());
        } else {
            if (n == 2) {
                throw new IllegalArgumentException("Deprecated mangling engine id");
            }
            if (n == 3) {
                this.engines.add(new QS());
            } else if (n == 4) {
                this.engines.add(new YI());
            } else {
                throw new IllegalArgumentException("Unknown mangling engine id");
            }
        }
    }

    public boolean importUnmangledRoutineName(INativeMethodItem iNativeMethodItem, String string, IUnmangledRoutine iUnmangledRoutine, boolean bl2) {
        if (!(iNativeMethodItem instanceof xs) || iUnmangledRoutine == null || iNativeMethodItem.getName(true) == null) {
            return false;
        }
        String string2 = iUnmangledRoutine.getName();
        if (string2 != null) {
            ((xs)iNativeMethodItem).eO(string);
            ((xs)iNativeMethodItem).Qx(string2);
            iNativeMethodItem.setName(string2);
            String string3 = iUnmangledRoutine.getFull();
            if (string3 != null) {
                ((xs)iNativeMethodItem).Le(string3);
            }
        }
        return true;
    }

    public boolean importUnmangledRoutinePrototype(INativeMethodItem iNativeMethodItem, IUnmangledRoutine iUnmangledRoutine) {
        if (!(iNativeMethodItem instanceof xs) || iUnmangledRoutine == null) {
            return false;
        }
        this.disableRedecompilation();
        String string = iUnmangledRoutine.getPrototype(true);
        boolean bl2 = false;
        if (string != null) {
            bl2 = this.codeUnit.setRoutinePrototype(iNativeMethodItem, string);
        }
        this.enableRedecompilation();
        return bl2;
    }

    private void disableRedecompilation() {
        if (this.decompilers == null || this.decompilers.isEmpty()) {
            this.decompilers = UnitUtil.findChildrenByType(this.codeUnit, Qn.class, true);
        }
        if (this.decompilers != null) {
            for (Qn qn2 : this.decompilers) {
                qn2.Qx(true);
            }
        }
    }

    private void enableRedecompilation() {
        if (this.decompilers != null) {
            for (Qn qn2 : this.decompilers) {
                qn2.Qx(false);
            }
        }
    }

    public IUnmangledRoutine unmangleRoutine(String string, boolean bl2) {
        if (this.engines.isEmpty()) {
            return null;
        }
        IUnmangledRoutine iUnmangledRoutine = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData = iManglingEngine.unmangle(string);
            if (!(iUnmangledData instanceof IUnmangledRoutine)) continue;
            IUnmangledRoutine iUnmangledRoutine2 = (IUnmangledRoutine)iUnmangledData;
            if (bl2) {
                return iUnmangledRoutine2;
            }
            if (iUnmangledRoutine != null && !iUnmangledRoutine2.getFull().equals(iUnmangledRoutine.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", iUnmangledRoutine.getFull(), iUnmangledRoutine2.getFull());
                return null;
            }
            iUnmangledRoutine = iUnmangledRoutine2;
        }
        return iUnmangledRoutine;
    }

    public IUnmangledData unmangleData(String string, boolean bl2) {
        if (this.engines.isEmpty()) {
            return null;
        }
        pZ pZ2 = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData = iManglingEngine.unmangle(string);
            if (!(iUnmangledData instanceof pZ)) continue;
            pZ pZ3 = (pZ)iUnmangledData;
            if (bl2) {
                return pZ3;
            }
            if (pZ2 != null && !pZ3.getFull().equals(pZ2.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", pZ2.getFull(), pZ3.getFull());
                return null;
            }
            pZ2 = pZ3;
        }
        return pZ2;
    }

    public IUnmangledData unmangle(String string, boolean bl2) {
        if (this.engines.isEmpty()) {
            return null;
        }
        IUnmangledData iUnmangledData = null;
        for (IManglingEngine iManglingEngine : this.engines) {
            IUnmangledData iUnmangledData2 = iManglingEngine.unmangle(string);
            if (iUnmangledData2 == null) continue;
            if (bl2) {
                return iUnmangledData2;
            }
            if (iUnmangledData != null && !iUnmangledData2.getFull().equals(iUnmangledData.getFull())) {
                logger.warn("> conflicting results from unmangling engines (%s , %s)", iUnmangledData.getFull(), iUnmangledData2.getFull());
                return null;
            }
            iUnmangledData = iUnmangledData2;
        }
        return iUnmangledData;
    }
}

