/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt;

import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IdRanges;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.AbstractMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptFilterCanDiscard;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerEntry;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.BO;
import com.pnfsoftware.jebglobal.Cf;
import com.pnfsoftware.jebglobal.Dl;
import com.pnfsoftware.jebglobal.FE;
import com.pnfsoftware.jebglobal.IN;
import com.pnfsoftware.jebglobal.Jy;
import com.pnfsoftware.jebglobal.KD;
import com.pnfsoftware.jebglobal.Po;
import com.pnfsoftware.jebglobal.Qm;
import com.pnfsoftware.jebglobal.Qs;
import com.pnfsoftware.jebglobal.Tq;
import com.pnfsoftware.jebglobal.US;
import com.pnfsoftware.jebglobal.Uv;
import com.pnfsoftware.jebglobal.XF;
import com.pnfsoftware.jebglobal.Ye;
import com.pnfsoftware.jebglobal.Zi;
import com.pnfsoftware.jebglobal.dy;
import com.pnfsoftware.jebglobal.gC;
import com.pnfsoftware.jebglobal.go;
import com.pnfsoftware.jebglobal.hJ;
import com.pnfsoftware.jebglobal.jB;
import com.pnfsoftware.jebglobal.nm;
import com.pnfsoftware.jebglobal.oP;
import com.pnfsoftware.jebglobal.pK;
import com.pnfsoftware.jebglobal.qT;
import com.pnfsoftware.jebglobal.qa;
import com.pnfsoftware.jebglobal.rL;
import com.pnfsoftware.jebglobal.vG;
import com.pnfsoftware.jebglobal.vc;
import com.pnfsoftware.jebglobal.xx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EMasterOptimizer
extends AbstractMasterOptimizer<IERoutineContext> {
    private static final StructuredLogger logger = qT.eO(EMasterOptimizer.class);
    public static int defaultMaxRunCount = -1;
    private List<IOptFilterCanDiscard> disregardedOutputFilters = new ArrayList<IOptFilterCanDiscard>();
    private Set<Integer> disregardedOutputRegisters;
    private Map<Integer, jB> defaultInput;

    public EMasterOptimizer(IERoutineContext iERoutineContext) {
        this(iERoutineContext, -1);
    }

    public EMasterOptimizer(IERoutineContext iERoutineContext, int n) {
        super(iERoutineContext, n);
        this.registerOptimizer(new Zi(iERoutineContext));
        this.registerOptimizer(new oP(this));
        this.registerOptimizer(new US(this));
        this.registerOptimizer(new go(this));
        this.registerOptimizer(new gC(this));
        this.registerOptimizer(new Qs(iERoutineContext));
        this.registerOptimizer(new IN(iERoutineContext));
        this.registerOptimizer(new BO(iERoutineContext));
        this.registerOptimizer(new Uv(iERoutineContext));
        this.registerOptimizer(new XF(iERoutineContext));
        this.registerOptimizer(new nm(iERoutineContext));
        this.registerOptimizer(new rL(iERoutineContext));
        this.registerOptimizer(new Tq(iERoutineContext));
        this.registerOptimizer(new Ye(iERoutineContext));
        this.registerOptimizer(new vc(iERoutineContext));
        this.registerOptimizer(new xx(iERoutineContext));
        this.registerOptimizer(new Qm(iERoutineContext));
        this.registerOptimizer(new FE(iERoutineContext));
        this.registerOptimizer(new hJ(iERoutineContext));
        this.registerOptimizer(new KD(iERoutineContext));
        this.registerOptimizer(new Jy(iERoutineContext));
        this.registerOptimizer(new vG(iERoutineContext));
        this.registerOptimizer(new Po(iERoutineContext));
        this.registerOptimizer(new Dl(iERoutineContext));
        this.registerOptimizer(new pK(iERoutineContext));
        this.registerOptimizer(new Cf(this));
        this.registerOptimizer(new qa(iERoutineContext));
    }

    public void addDisregardedOutputFilter(IOptFilterCanDiscard iOptFilterCanDiscard) {
        this.disregardedOutputFilters.add(iOptFilterCanDiscard);
    }

    public void addDisregardedOutputBits(Collection<Integer> collection) {
        if (this.disregardedOutputRegisters == null) {
            this.disregardedOutputRegisters = new HashSet<Integer>();
        }
        this.disregardedOutputRegisters.addAll(collection);
    }

    public void addDisregardedOutputVariables(Collection<? extends IEVar> collection) {
        if (this.disregardedOutputRegisters == null) {
            this.disregardedOutputRegisters = new HashSet<Integer>();
        }
        for (IEVar iEVar : collection) {
            ((dy)iEVar).eO(this.disregardedOutputRegisters);
        }
    }

    public Set<Integer> getDisregardedOutputRegisters() {
        return this.disregardedOutputRegisters;
    }

    public void addDefaultInput(int n, IEImm iEImm) {
        if (this.defaultInput == null) {
            this.defaultInput = new HashMap<Integer, jB>();
        }
        this.defaultInput.put(n, (jB)iEImm);
    }

    public IEImm getDefaultInput(int n) {
        return this.defaultInput == null ? null : (IEImm)this.defaultInput.get(n);
    }

    public static boolean isReachingRoutineOutput(CFG<IEStatement> cFG, int n) {
        for (BasicBlock<IEStatement> basicBlock : cFG.getExitBlocks()) {
            if (!basicBlock.getTrackerReachingRegisters().getOutputs().containsKey(n)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefinitionReachingRoutineOutput(CFG<IEStatement> cFG, int n, long l2) {
        return EMasterOptimizer.getDefinitionReachingRoutineOutput(cFG, n, l2) >= 0;
    }

    public static int getDefinitionReachingRoutineOutput(CFG<IEStatement> cFG, int n, long l2) {
        for (BasicBlock<IEStatement> basicBlock : cFG.getExitBlocks()) {
            Set<Long> set = basicBlock.getTrackerReachingRegisters().getOutputs().get(n);
            if (set == null) continue;
            if (set.contains(l2)) {
                return 1;
            }
            for (Long l3 : set) {
                IEStatement iEStatement = cFG.getInstruction(l3);
                IdRanges idRanges = new IdRanges();
                IdRanges idRanges2 = new IdRanges();
                if (!(iEStatement instanceof IEAssign) || ((IEAssign)iEStatement).isRoutineCall() || ((IEAssign)iEStatement).isBreakingFlow()) continue;
                ((IEAssign)iEStatement).getLeftOperand().getDefinedOrUsedAsDestination(idRanges, idRanges2);
                if (idRanges.containsVarFull(n)) continue;
                return 0;
            }
        }
        return -1;
    }

    public boolean canDiscardUnusedDefinition(CFG<IEStatement> cFG, int n, long l2) {
        if (n >= 65536 && n < 131072) {
            return true;
        }
        if (this.disregardedOutputRegisters != null && this.disregardedOutputRegisters.contains(n)) {
            return true;
        }
        for (IOptFilterCanDiscard iOptFilterCanDiscard : this.disregardedOutputFilters) {
            if (!iOptFilterCanDiscard.check(cFG, l2, n)) continue;
            return true;
        }
        if (!EMasterOptimizer.isDefinitionReachingRoutineOutput(cFG, n, l2)) {
            return true;
        }
        if (n >= 0x1000000) {
            return false;
        }
        return this.getMode() >= 10;
    }

    @Override
    protected void postOptimizationCallback(IERoutineContext iERoutineContext, OptimizerEntry<IERoutineContext> optimizerEntry, int n, long l2) {
        super.postOptimizationCallback(iERoutineContext, optimizerEntry, n, l2);
    }

    @Override
    protected void postAllOptimizationsCallback(IERoutineContext iERoutineContext) {
        super.postAllOptimizationsCallback(iERoutineContext);
        this.debugCheckGraph();
    }

    private void debugCheckGraph() {
    }

    @Override
    protected void preAllOptimizationsCallback(IERoutineContext iERoutineContext) {
        super.preAllOptimizationsCallback(iERoutineContext);
    }
}

