/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public enum OperationType {
    ADD("+", 2),
    SUB("-", 2),
    MUL_S("*", 2),
    MUL_U("*u", 2),
    DIV_S("/", 2),
    DIV_U("/u", 2),
    REM_S("%", 2),
    REM_U("%u", 2),
    MUL2_S("**", 2),
    MUL2_U("**u", 2),
    DIV2_S("//", 2),
    DIV2_U("//u", 2),
    AND("&", 2),
    OR("|", 2),
    XOR("^", 2),
    NOT("~", 1),
    LOG_AND("&&", 2),
    LOG_OR("||", 2),
    LOG_NOT("!", 1),
    LOG_EQ("==", 2),
    LOG_NEQ("!=", 2),
    LT_S("<", 2),
    LE_S("<=", 2),
    GT_S(">", 2),
    GE_S(">=", 2),
    LT_U("<u", 2),
    LE_U("<=u", 2),
    GT_U(">u", 2),
    GE_U(">=u", 2),
    SHL("<<", 2),
    SHR(">>>", 2),
    SAR(">>", 2),
    ROR("ror", 2),
    ROL("rol", 2),
    PAR("PARITY", 1),
    SP2EDP("SP2EDP", 1),
    DP2EDP("DP2EDP", 1),
    INT2EDP("INT2EDP", 1),
    LONG2EDP("LONG2EDP", 1),
    CAST("CAST", 1),
    CAST_S("SIGNED_CAST", 1),
    CARRY("CARRY", 2),
    POW("**", 2);

    private final String repr;
    private final int minParameters;
    private final int maxParameters;

    private OperationType(String string2, int n2) {
        this(string2, n2, n2);
    }

    private OperationType(String string2, int n2, int n3) {
        this.repr = string2;
        this.minParameters = n2;
        this.maxParameters = n3;
    }

    public boolean isValid(int n) {
        if (this.minParameters >= 0 && n < this.minParameters) {
            return false;
        }
        return this.maxParameters < 0 || n <= this.maxParameters;
    }

    public int getMinParameters() {
        return this.minParameters;
    }

    public int getMaxParameters() {
        return this.maxParameters;
    }

    public String toString() {
        return this.repr;
    }
}

