/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.util.collect.IntegerSegment;
import com.pnfsoftware.jeb.util.collect.SegmentMap;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

@Ser
public class IdRanges {
    @SerId(value=1)
    Map<Integer, IEVar> fullVars = new HashMap<Integer, IEVar>();
    @Deprecated
    @SerId(value=2)
    Map<Integer, Integer> ranges = new HashMap<Integer, Integer>();
    @SerId(value=3)
    private Map<Integer, SegmentMap<Integer, IntegerSegment>> rangesFull = new HashMap<Integer, SegmentMap<Integer, IntegerSegment>>();

    @SerCustomInit
    private void init() {
        if (this.ranges != null && !this.ranges.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : this.ranges.entrySet()) {
                IEVar iEVar = this.getFullVarById(entry.getKey());
                this.add(iEVar, iEVar.getId(), entry.getValue());
            }
            this.ranges.clear();
        }
    }

    public void clear() {
        this.fullVars.clear();
        this.rangesFull.clear();
    }

    public int bsize() {
        int n = 0;
        for (SegmentMap<Integer, IntegerSegment> segmentMap : this.rangesFull.values()) {
            for (IntegerSegment integerSegment : segmentMap.values()) {
                n += integerSegment.getSize();
            }
        }
        return n;
    }

    public int size() {
        return this.fullVars.size();
    }

    public void addAll(Collection<? extends IEVar> collection) {
        for (IEVar iEVar : collection) {
            this.add(iEVar);
        }
    }

    public void add(IEVar iEVar) {
        this.add(iEVar, iEVar.getId(), iEVar.getBitsize());
    }

    public void add(IEVar iEVar, int n, int n2) {
        ArrayList<IntegerSegment> arrayList;
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(iEVar.getId());
        if (segmentMap == null) {
            segmentMap = new SegmentMap();
            segmentMap.setRemoveSegmentsOnOverlap(true);
            this.rangesFull.put(iEVar.getId(), segmentMap);
        }
        if (n < 0) {
            n = n - n2 + 1;
        }
        int n3 = n + n2;
        SortedMap<Integer, IntegerSegment> sortedMap = segmentMap.getOverlappingSegmentsMap(n, true, n3, true);
        if (!sortedMap.isEmpty()) {
            arrayList = new ArrayList<IntegerSegment>(sortedMap.values());
            IntegerSegment integerSegment = (IntegerSegment)arrayList.get(0);
            if (integerSegment.getBegin().compareTo(n) < 0) {
                n = integerSegment.getBegin();
            }
            if ((integerSegment = (IntegerSegment)arrayList.get(arrayList.size() - 1)).getEnd().compareTo(n3) > 0) {
                n3 = integerSegment.getEnd();
            }
            for (Integer n4 : sortedMap.keySet()) {
                segmentMap.remove(n4);
            }
        }
        arrayList = new IntegerSegment(n, n3 - n);
        segmentMap.add((IntegerSegment)((Object)arrayList));
        this.fullVars.put(iEVar.getId(), iEVar);
    }

    public boolean containsVarPart(IEVar iEVar) {
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(iEVar.getId());
        return segmentMap != null && !segmentMap.isEmpty();
    }

    public boolean containsVarFull(IEVar iEVar) {
        SegmentMap<Integer, IntegerSegment> segmentMap = this.rangesFull.get(iEVar.getId());
        return segmentMap != null && segmentMap.size() == 1 && ((IntegerSegment)segmentMap.values().iterator().next()).getSize() == iEVar.getBitsize();
    }

    public boolean containsVarFull(int n) {
        IEVar iEVar = this.fullVars.get(n);
        if (iEVar != null) {
            return this.containsVarFull(iEVar);
        }
        return false;
    }

    public List<IEVar> getVars() {
        ArrayList<IEVar> arrayList = new ArrayList<IEVar>();
        this.collectVars(arrayList);
        return arrayList;
    }

    public void collectVars(List<IEVar> list) {
        list.addAll(this.fullVars.values());
    }

    public List<Integer> getVarIds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectVarIds(arrayList);
        return arrayList;
    }

    public void collectVarIds(Collection<Integer> collection) {
        collection.addAll(this.fullVars.keySet());
    }

    public List<Integer> getBits() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.collectBits(arrayList);
        return arrayList;
    }

    public void collectBits(List<Integer> list) {
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : this.rangesFull.entrySet()) {
            for (IntegerSegment integerSegment : entry.getValue().values()) {
                int n = integerSegment.getBegin();
                int n2 = integerSegment.getEnd();
                while (n < n2) {
                    list.add(n++);
                }
            }
        }
    }

    public IdRanges intersection(IdRanges idRanges) {
        Map<Integer, SegmentMap<Integer, IntegerSegment>> map = this.intersect(this.rangesFull, idRanges.rangesFull);
        if (map.size() == 0) {
            return null;
        }
        IdRanges idRanges2 = new IdRanges();
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : map.entrySet()) {
            IEVar iEVar = this.getFullVarById(entry.getKey());
            if (iEVar == null) {
                throw new RuntimeException(String.format("Error with intersection of var %d", entry.getKey()));
            }
            for (IntegerSegment integerSegment : entry.getValue().values()) {
                int n = integerSegment.getBegin();
                if (integerSegment.getBegin() < 0) {
                    n = n + integerSegment.getSize() - 1;
                }
                idRanges2.add(iEVar, n, integerSegment.getSize());
            }
        }
        return idRanges2;
    }

    private IEVar getFullVarById(int n) {
        Collection<IEVar> collection = this.fullVars.values();
        for (IEVar iEVar : collection) {
            if (iEVar.getId() != n) continue;
            return iEVar;
        }
        return null;
    }

    private Map<Integer, SegmentMap<Integer, IntegerSegment>> intersect(Map<Integer, SegmentMap<Integer, IntegerSegment>> map, Map<Integer, SegmentMap<Integer, IntegerSegment>> map2) {
        HashMap<Integer, SegmentMap<Integer, IntegerSegment>> hashMap = new HashMap<Integer, SegmentMap<Integer, IntegerSegment>>();
        for (Map.Entry<Integer, SegmentMap<Integer, IntegerSegment>> entry : map.entrySet()) {
            int n = entry.getKey();
            SegmentMap<Integer, IntegerSegment> segmentMap = entry.getValue();
            SegmentMap<Integer, IntegerSegment> segmentMap2 = map2.get(n);
            if (segmentMap == null || segmentMap2 == null) continue;
            SegmentMap<Integer, IntegerSegment> segmentMap3 = new SegmentMap<Integer, IntegerSegment>();
            segmentMap3.setRemoveSegmentsOnOverlap(true);
            for (IntegerSegment integerSegment : segmentMap.values()) {
                for (IntegerSegment integerSegment2 : segmentMap2.values()) {
                    if (integerSegment.getBegin() >= integerSegment2.getEnd() || integerSegment2.getBegin() >= integerSegment.getEnd()) continue;
                    int n2 = Math.max(integerSegment.getBegin(), integerSegment2.getBegin());
                    int n3 = Math.min(integerSegment.getEnd(), integerSegment2.getEnd());
                    segmentMap3.put(n2, new IntegerSegment(n2, n3 - n2));
                }
            }
            if (segmentMap3.isEmpty()) continue;
            hashMap.put(n, segmentMap3);
        }
        return hashMap;
    }

    public boolean hasIntersection(IdRanges idRanges) {
        return this.intersection(idRanges) != null;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.fullVars == null ? 0 : this.fullVars.hashCode());
        n2 = 31 * n2 + (this.rangesFull == null ? 0 : this.rangesFull.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IdRanges idRanges = (IdRanges)object;
        if (this.fullVars == null ? idRanges.fullVars != null : !this.fullVars.equals(idRanges.fullVars)) {
            return false;
        }
        return !(this.rangesFull == null ? idRanges.rangesFull != null : !this.rangesFull.equals(idRanges.rangesFull));
    }
}

