/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COperatorType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICAssignment;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantInteger;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICControlBreaker;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICExpression;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGoto;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIdentifier;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIfStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICLabel;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICOperator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICPredicate;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICWhileStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorLog;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorState;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import java.util.List;

public class SimpleCEmulator {
    private static final ILogger logger = GlobalLog.getLogger(SimpleCEmulator.class);
    private static final int RETURN_REGISTER_ID = -65536;

    public EmulatorLog emulate(ICMethod iCMethod, EmulatorState emulatorState) {
        EmulatorLog emulatorLog = new EmulatorLog();
        CFG cFG = CFG.buildCFG(iCMethod);
        ICStatement iCStatement = cFG.getEntryPoint();
        EmulatorState emulatorState2 = emulatorState;
        while (iCStatement != null) {
            emulatorLog.addExecutedStatement(iCStatement);
            iCStatement = this.emulateStatement(emulatorState2, cFG, iCStatement);
        }
        emulatorLog.setEmulatorState(emulatorState2);
        return emulatorLog;
    }

    private ICStatement emulateStatement(EmulatorState emulatorState, CFG cFG, ICStatement iCStatement) {
        if (iCStatement instanceof ICGoto) {
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICLabel) {
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICReturn) {
            ICExpression iCExpression = ((ICReturn)iCStatement).getExpression();
            if (iCExpression != null) {
                emulatorState.setRegisterValue(-65536, this.evaluateExpression(emulatorState, iCExpression));
            }
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICAssignment) {
            this.evaluateAssignment(emulatorState, (ICAssignment)((Object)iCStatement));
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICIfStm) {
            ICIfStm iCIfStm = (ICIfStm)iCStatement;
            List<? extends ICPredicate> list = iCIfStm.getBranchPredicates();
            for (int j = 0; j < list.size(); ++j) {
                if (this.evaluateExpression(emulatorState, list.get(j)) == 0L) continue;
                return cFG.getConditionalTarget(iCStatement, j);
            }
            if (((ICIfStm)iCStatement).hasDefaultBlock()) {
                return cFG.getConditionalTarget(iCStatement, list.size());
            }
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICWhileStm) {
            ICWhileStm iCWhileStm = (ICWhileStm)iCStatement;
            if (this.evaluateExpression(emulatorState, iCWhileStm.getPredicate()) != 0L) {
                return cFG.getConditionalTarget(iCWhileStm);
            }
            return cFG.getFallThroughTarget(iCWhileStm);
        }
        if (iCStatement instanceof ICBlock) {
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICControlBreaker) {
            return cFG.getFallThroughTarget(iCStatement);
        }
        if (iCStatement instanceof ICCall) {
            this.emulateCalledRoutine(emulatorState, ((ICCall)iCStatement).getMethod(), ((ICCall)iCStatement).getArguments());
            return cFG.getFallThroughTarget(iCStatement);
        }
        throw new EmulatorException(String.format("ERROR: unimplemented statement emulation (%s)", iCStatement));
    }

    private void evaluateAssignment(EmulatorState emulatorState, ICAssignment iCAssignment) {
        if (iCAssignment.isSimpleAssignment()) {
            Long l2 = this.evaluateExpression(emulatorState, iCAssignment.getRight());
            if (l2 == null) {
                throw new EmulatorException(String.format("right value evaluation (%s)", iCAssignment));
            }
            ICExpression iCExpression = this.getDereferencedExpression(iCAssignment.getLeft());
            if (iCExpression != null) {
                Long l3 = this.evaluateExpression(emulatorState, iCExpression);
                if (l3 != null && ((ICOperation)((Object)iCAssignment.getLeft())).getFirstOperand() instanceof ICOperation) {
                    ICOperation iCOperation = (ICOperation)((ICOperation)((Object)iCAssignment.getLeft())).getFirstOperand();
                    if (iCOperation.getOperator().isCast()) {
                        emulatorState.writeMemory(l3, l2, 4);
                    } else {
                        emulatorState.writeMemory(l3, l2, 8);
                    }
                }
            } else {
                emulatorState.setVarValue(iCAssignment.getLeft(), l2);
            }
        } else {
            throw new EmulatorException("ERROR: not implemented: non simple assignments");
        }
    }

    private ICExpression getDereferencedExpression(ICElement iCElement) {
        if (iCElement instanceof ICOperation && ((ICOperation)iCElement).getOperator().getInternalOperatorType() == COperatorType.PTR) {
            return ((ICOperation)iCElement).getFirstOperand();
        }
        return null;
    }

    private Long evaluateExpression(EmulatorState emulatorState, ICExpression iCExpression) {
        if (iCExpression instanceof ICConstantInteger) {
            return ((ICConstantInteger)iCExpression).getValueAsLong();
        }
        if (iCExpression instanceof ICOperation) {
            return this.evaluateOperation(emulatorState, (ICOperation)iCExpression);
        }
        if (iCExpression instanceof ICIdentifier) {
            Long l2 = emulatorState.getVarValue((ICIdentifier)iCExpression);
            if (l2 == null) {
                throw new EmulatorException(String.format("non initialized identifier (%s)", iCExpression));
            }
            return l2;
        }
        if (iCExpression instanceof ICPredicate) {
            return this.evaluateExpression(emulatorState, ((ICPredicate)iCExpression).getExpression()) != 0L ? 1L : 0L;
        }
        if (iCExpression instanceof ICCall) {
            return this.emulateCalledRoutine(emulatorState, ((ICCall)iCExpression).getMethod(), ((ICCall)iCExpression).getArguments());
        }
        throw new EmulatorException(String.format("ERROR: unimplemented expression eval (%s)", iCExpression));
    }

    private Long emulateCalledRoutine(EmulatorState emulatorState, ICMethod iCMethod, List<ICExpression> list) {
        if (iCMethod.getName().equals("_ptr_time")) {
            return 42L;
        }
        if (iCMethod.getName().equals("_ptr_srand")) {
            return 37L;
        }
        if (iCMethod.getName().equals("_ptr_memcpy")) {
            ICExpression iCExpression = list.get(0);
            ICExpression iCExpression2 = list.get(1);
            ICExpression iCExpression3 = list.get(2);
            if (iCExpression2 instanceof ICConstantInteger && iCExpression3 instanceof ICConstantInteger) {
                long l2 = ((ICConstantInteger)iCExpression2).getValueAsLong();
                int n = (int)((ICConstantInteger)iCExpression3).getValueAsLong();
                long l3 = this.evaluateExpression(emulatorState, iCExpression);
                emulatorState.copyMemory(l2, l3, n);
                return l3;
            }
            throw new EmulatorException("TBI: memcpy");
        }
        throw new EmulatorException(String.format("ERROR: unimplemented called method simulation (%s)", iCMethod.getName()));
    }

    private Long evaluateOperation(EmulatorState emulatorState, ICOperation iCOperation) {
        Long l2 = null;
        ICExpression iCExpression = iCOperation.getFirstOperand();
        ICExpression iCExpression2 = iCOperation.getSecondOperand();
        ICExpression iCExpression3 = iCOperation.getThirdOperand();
        ICOperator iCOperator = iCOperation.getOperator();
        switch (iCOperator.getInternalOperatorType()) {
            case ADD: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) + this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case AND: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) & this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case CAST: {
                int n = emulatorState.getTypeSize(iCOperator.getCastType());
                long l3 = MathUtil.makeMask(n * 8);
                l2 = this.evaluateExpression(emulatorState, iCExpression) & l3;
                break;
            }
            case COND: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) != 0L ? this.evaluateExpression(emulatorState, iCExpression2) : this.evaluateExpression(emulatorState, iCExpression3);
                break;
            }
            case CUSTOM: {
                break;
            }
            case DIV: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) / this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case EQ: {
                l2 = this.evaluateExpression(emulatorState, iCExpression).equals(this.evaluateExpression(emulatorState, iCExpression2)) ? 1L : 0L;
                break;
            }
            case GE: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) >= this.evaluateExpression(emulatorState, iCExpression2) ? 1L : 0L;
                break;
            }
            case GT: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) > this.evaluateExpression(emulatorState, iCExpression2) ? 1L : 0L;
                break;
            }
            case LE: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) <= this.evaluateExpression(emulatorState, iCExpression2) ? 1L : 0L;
                break;
            }
            case LOG_AND: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) != 0L && this.evaluateExpression(emulatorState, iCExpression2) != 0L ? 1L : 0L;
                break;
            }
            case LOG_IDENT: {
                l2 = this.evaluateExpression(emulatorState, iCExpression);
                break;
            }
            case LOG_NOT: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) != 0L ? 0L : 1L;
                break;
            }
            case LOG_OR: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) != 0L || this.evaluateExpression(emulatorState, iCExpression2) != 0L ? 1L : 0L;
                break;
            }
            case LT: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) < this.evaluateExpression(emulatorState, iCExpression2) ? 1L : 0L;
                break;
            }
            case MUL: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) * this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case NE: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) != this.evaluateExpression(emulatorState, iCExpression2) ? 1L : 0L;
                break;
            }
            case NEG: {
                l2 = -this.evaluateExpression(emulatorState, iCExpression).longValue();
                break;
            }
            case NOT: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case OR: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) | this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case PTR: {
                if (iCExpression instanceof ICIdentifier) {
                    l2 = emulatorState.readMemory(this.evaluateExpression(emulatorState, iCExpression), emulatorState.getBaseTypeSize(((ICIdentifier)iCExpression).getType()));
                    break;
                }
                if (iCExpression instanceof ICOperation) {
                    ICIdentifier iCIdentifier = this.getBasePointer((ICOperation)iCExpression);
                    if (((ICOperation)iCExpression).getOperator().isCast()) {
                        int n = emulatorState.getBaseTypeSize(((ICOperation)iCExpression).getOperator().getCastType());
                        l2 = emulatorState.readMemory(this.evaluateExpression(emulatorState, ((ICOperation)iCExpression).getFirstOperand()), n);
                        l2 = MathUtil.signExtend(l2, n * 8);
                        break;
                    }
                    if (iCIdentifier != null) {
                        l2 = emulatorState.readMemory(this.evaluateExpression(emulatorState, iCExpression), emulatorState.getBaseTypeSize(iCIdentifier.getType()));
                        break;
                    }
                    if (emulatorState.getDefaultPointerSize() != null) {
                        l2 = emulatorState.readMemory(this.evaluateExpression(emulatorState, iCExpression), emulatorState.getDefaultPointerSize());
                        break;
                    }
                    throw new EmulatorException("cant find size to read for PTR operation");
                }
                if (iCExpression instanceof ICConstantInteger) {
                    logger.info("> warning: read with fixed size (%d) at address %x", emulatorState.getDefaultPointerSize(), ((ICConstantInteger)iCExpression).getValueAsLong());
                    l2 = emulatorState.readMemorySafe(((ICConstantInteger)iCExpression).getValueAsLong(), emulatorState.getDefaultPointerSize());
                    break;
                }
                throw new EmulatorException(String.format("PTR invalid (%s)", iCExpression));
            }
            case REF: {
                if (!(iCExpression instanceof ICIdentifier)) {
                    throw new EmulatorException(String.format("REF on non id (%s)", iCExpression));
                }
                l2 = emulatorState.getVarAddress((ICIdentifier)iCExpression);
                break;
            }
            case REM: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) % this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case SHL: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) << (int)this.evaluateExpression(emulatorState, iCExpression2).longValue();
                break;
            }
            case SHR: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) >> (int)this.evaluateExpression(emulatorState, iCExpression2).longValue();
                break;
            }
            case SIZEOF: {
                break;
            }
            case SUB: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) - this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
            case USHR: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) >>> (int)this.evaluateExpression(emulatorState, iCExpression2).longValue();
                break;
            }
            case XOR: {
                l2 = this.evaluateExpression(emulatorState, iCExpression) ^ this.evaluateExpression(emulatorState, iCExpression2);
                break;
            }
        }
        if (l2 == null) {
            throw new EmulatorException(String.format("TBI: operator (%s)", iCOperator));
        }
        return l2;
    }

    public ICIdentifier getBasePointer(ICOperation iCOperation) {
        ICIdentifier iCIdentifier = null;
        if (iCOperation.getFirstOperand() instanceof ICIdentifier) {
            iCIdentifier = (ICIdentifier)iCOperation.getFirstOperand();
        } else if (iCOperation.getSecondOperand() instanceof ICIdentifier) {
            iCIdentifier = (ICIdentifier)iCOperation.getSecondOperand();
        } else if (iCOperation.getThirdOperand() instanceof ICIdentifier) {
            iCIdentifier = (ICIdentifier)iCOperation.getThirdOperand();
        }
        return iCIdentifier;
    }
}

