/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.IUnitFilter;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;

public class UnitUtil {
    public static final String pdmRegionText = "text";
    public static final String pdmRegionParsers = "parsers";

    public static void notifyGenericChange(IUnit iUnit) {
        iUnit.notifyListeners(new JebEvent(J.UnitChange));
    }

    static void log(IUnit iUnit, String string, boolean bl2, ILogger iLogger, int n, String string2, Object ... objectArray) {
        block11: {
            try {
                String string3;
                if (string2 == null || iUnit == null) break block11;
                if (bl2) {
                    try {
                        NotificationType notificationType;
                        string3 = String.format(string2, objectArray);
                        switch (n) {
                            case 50: {
                                notificationType = NotificationType.ERROR;
                                break;
                            }
                            case 40: {
                                notificationType = NotificationType.WARNING;
                                break;
                            }
                            case 30: {
                                notificationType = NotificationType.INFO;
                                break;
                            }
                            default: {
                                notificationType = NotificationType.AREA_OF_INTEREST;
                            }
                        }
                        iUnit.getNotificationManager().addNotification(new UnitNotification(notificationType, string3, string));
                    }
                    catch (NullPointerException | IllegalFormatException runtimeException) {
                        // empty catch block
                    }
                }
                if ((string3 = UnitUtil.buildFullyQualifiedUnitPath(iUnit)) != null) {
                    string2 = String.format("{%s}: %s", string3.replace("%", "%%"), string2);
                }
            }
            catch (Exception exception) {
                iLogger.catchingSilent(exception);
            }
        }
        iLogger.log(n, false, string2, objectArray);
    }

    public static void logInfo(IUnit iUnit, String string, boolean bl2, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl2, iLogger, 30, string2, objectArray);
    }

    public static void logWarn(IUnit iUnit, String string, boolean bl2, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl2, iLogger, 40, string2, objectArray);
    }

    public static void logError(IUnit iUnit, String string, boolean bl2, ILogger iLogger, String string2, Object ... objectArray) {
        UnitUtil.log(iUnit, string, bl2, iLogger, 50, string2, objectArray);
    }

    public static void logException(IUnit iUnit, ILogger iLogger, Exception exception) {
        String string = String.format("EXCEPTION: %s", exception.getMessage());
        Throwable throwable = Throwables.getRootCause(exception);
        if (throwable != null && throwable != exception && throwable.getMessage() != null) {
            string = string + String.format(" (cause: %s)", throwable.getMessage());
        }
        UnitUtil.logError(iUnit, null, false, iLogger, string, new Object[0]);
        iLogger.log(20, false, Throwables.formatStacktrace(exception), new Object[0]);
    }

    public static List<IUnit> filterDescendants(IUnit iUnit, int n, IUnitFilter iUnitFilter) {
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (IUnit iUnit2 : iUnit.getChildren()) {
            UnitUtil.filterDescendantsRecurse(iUnit2, n, iUnitFilter, arrayList);
        }
        return arrayList;
    }

    private static void filterDescendantsRecurse(IUnit iUnit, int n, IUnitFilter iUnitFilter, List<IUnit> list) {
        if (iUnit != null && n != 0) {
            if (iUnitFilter == null || iUnitFilter.check(iUnit)) {
                list.add(iUnit);
            }
            if (n - 1 != 0) {
                for (IUnit iUnit2 : iUnit.getChildren()) {
                    UnitUtil.filterDescendantsRecurse(iUnit2, n - 1, iUnitFilter, list);
                }
            }
        }
    }

    public static <T extends IUnit> List<T> findDescendantsByType(IUnit iUnit, int n, final Class<T> clazz, final boolean bl2) {
        return UnitUtil.filterDescendants(iUnit, n, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return clazz == null || clazz == iUnit.getClass() || !bl2 && clazz.isInstance(iUnit);
            }
        });
    }

    public static <T extends IUnit> List<T> findChildrenByType(IUnit iUnit, Class<T> clazz, boolean bl2) {
        return UnitUtil.findDescendantsByType(iUnit, 1, clazz, bl2);
    }

    public static <T extends IUnit> T findChildByType(IUnit iUnit, Class<T> clazz, boolean bl2, int n) {
        List<T> list = UnitUtil.findChildrenByType(iUnit, clazz, bl2);
        return (T)(n >= list.size() ? null : (IUnit)list.get(n));
    }

    public static <T extends IUnit> T findFirstChildByType(IUnit iUnit, Class<T> clazz, boolean bl2) {
        return UnitUtil.findChildByType(iUnit, clazz, bl2, 0);
    }

    public static <T extends IUnit> List<T> findDescendantsByType(IUnit iUnit, Class<T> clazz, boolean bl2) {
        return UnitUtil.findDescendantsByType(iUnit, -1, clazz, bl2);
    }

    public static List<IUnit> findDescendantsByName(IUnit iUnit, int n, final String string) {
        return UnitUtil.filterDescendants(iUnit, n, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return Strings.equals(iUnit.getName(), string);
            }
        });
    }

    public static List<IUnit> findDescendantsByName(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByName(iUnit, -1, string);
    }

    public static List<IUnit> findChildrenByName(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByName(iUnit, 1, string);
    }

    public static IUnit findChildByName(IUnit iUnit, String string, int n) {
        List<IUnit> list = UnitUtil.findChildrenByName(iUnit, string);
        return n >= list.size() ? null : list.get(n);
    }

    public static IUnit findFirstChildByName(IUnit iUnit, String string) {
        return UnitUtil.findChildByName(iUnit, string, 0);
    }

    public static IUnit retrieve(IUnit iUnit, String ... stringArray) {
        IUnit iUnit2 = iUnit;
        for (String string : stringArray) {
            if ((iUnit2 = UnitUtil.findFirstChildByName(iUnit2, string)) != null) continue;
            return null;
        }
        return iUnit2;
    }

    public static IUnit retrieveProcessed(boolean bl2, IUnit iUnit, String ... stringArray) {
        IUnit iUnit2 = UnitUtil.retrieve(iUnit, stringArray);
        if (iUnit2 == null || !bl2) {
            return null;
        }
        if (!iUnit2.isProcessed() && !iUnit2.process()) {
            return null;
        }
        return iUnit2;
    }

    public static <T extends IUnit> List<T> findDescendants(IUnit iUnit, int n, final String string, final Class<T> clazz, final boolean bl2) {
        return UnitUtil.filterDescendants(iUnit, n, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                if (string != null && !string.equals(iUnit.getName())) {
                    return false;
                }
                return clazz == null || UnitUtil.isClassMatch(iUnit, clazz, bl2);
            }
        });
    }

    public static <T extends IUnit> List<T> findChildren(IUnit iUnit, String string, Class<T> clazz, boolean bl2) {
        return UnitUtil.findDescendants(iUnit, 1, string, clazz, bl2);
    }

    public static <T extends IUnit> T findChild(IUnit iUnit, String string, Class<T> clazz, boolean bl2, int n) {
        List<T> list = UnitUtil.findChildren(iUnit, string, clazz, bl2);
        return (T)(n >= list.size() ? null : (IUnit)list.get(n));
    }

    private static <T extends IUnit> boolean isClassMatch(IUnit iUnit, Class<T> clazz, boolean bl2) {
        return iUnit.getClass() == clazz || !bl2 && clazz.isInstance(iUnit);
    }

    public static <T extends IUnit> List<T> findDescendants(ILiveArtifact iLiveArtifact, int n, final String string, final Class<T> clazz, final boolean bl2) {
        IUnitFilter iUnitFilter = new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                if (string != null && !string.equals(iUnit.getName())) {
                    return false;
                }
                return clazz == null || UnitUtil.isClassMatch(iUnit, clazz, bl2);
            }
        };
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (IUnit iUnit : iLiveArtifact.getUnits()) {
            UnitUtil.filterDescendantsRecurse(iUnit, n, iUnitFilter, arrayList);
        }
        return arrayList;
    }

    public static <T extends IUnit> List<T> findAll(String string, Class<T> clazz, boolean bl2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        ICoreContext iCoreContext = JebCoreService.getExistingInstance();
        if (iCoreContext != null) {
            for (IEnginesContext iEnginesContext : iCoreContext.listEnginesContexts()) {
                for (IRuntimeProject iRuntimeProject : iEnginesContext.getProjects()) {
                    for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                        List<T> list = UnitUtil.findDescendants(iLiveArtifact, -1, string, clazz, bl2);
                        if (list == null) continue;
                        arrayList.addAll(list);
                    }
                }
            }
        }
        return arrayList;
    }

    public static <T extends IUnit> List<T> findDescendantsByFormatType(IUnit iUnit, int n, final String string) {
        return UnitUtil.filterDescendants(iUnit, n, new IUnitFilter(){

            @Override
            public boolean check(IUnit iUnit) {
                return Strings.equals(iUnit.getFormatType(), string);
            }
        });
    }

    public static List<IUnit> findDescendantsByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByFormatType(iUnit, -1, string);
    }

    public static List<IUnit> findChildrenByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findDescendantsByFormatType(iUnit, 1, string);
    }

    public static IUnit findChildByFormatType(IUnit iUnit, String string, int n) {
        List<IUnit> list = UnitUtil.findChildrenByFormatType(iUnit, string);
        return n >= list.size() ? null : list.get(n);
    }

    public static IUnit findFirstChildByFormatType(IUnit iUnit, String string) {
        return UnitUtil.findChildByFormatType(iUnit, string, 0);
    }

    public static boolean isAncestorOf(IUnit iUnit, IUnit iUnit2) {
        return UnitUtil.isAncestorOf(iUnit, iUnit2, false);
    }

    public static boolean isAncestorOf(IUnit iUnit, IUnit iUnit2, boolean bl2) {
        if (iUnit == null || iUnit2 == null) {
            return false;
        }
        int n = 0;
        while (true) {
            if (!(iUnit != iUnit2 || bl2 && n <= 0)) {
                return true;
            }
            if (!(iUnit.getParent() instanceof IUnit)) break;
            iUnit = (IUnit)iUnit.getParent();
            ++n;
        }
        return false;
    }

    public static String buildFullyQualifiedCandidateUnitPath(String string, IUnitCreator iUnitCreator, boolean bl2, String string2) {
        String string3 = string;
        for (IUnitCreator iUnitCreator2 = iUnitCreator; iUnitCreator2 != null && (!(iUnitCreator2 instanceof IArtifact) || bl2); iUnitCreator2 = iUnitCreator2.getParent()) {
            string3 = iUnitCreator2.getName() + string2 + string3;
        }
        return string3;
    }

    public static String buildFullyQualifiedUnitPath(IUnit iUnit, boolean bl2, String string) {
        String string2 = iUnit.getName();
        for (IUnitCreator iUnitCreator = iUnit.getParent(); iUnitCreator != null && (!(iUnitCreator instanceof IArtifact) || bl2); iUnitCreator = iUnitCreator.getParent()) {
            string2 = iUnitCreator.getName() + string + string2;
        }
        return string2;
    }

    public static List<String> buildFullyQualifiedUnitPathList(IUnitCreator iUnitCreator, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(iUnitCreator.getName());
        for (IUnitCreator iUnitCreator2 = iUnitCreator.getParent(); iUnitCreator2 != null && (!(iUnitCreator2 instanceof IArtifact) || bl2); iUnitCreator2 = iUnitCreator2.getParent()) {
            arrayList.add(0, iUnitCreator2.getName());
        }
        return arrayList;
    }

    public static String buildFullyQualifiedUnitPath(IUnit iUnit) {
        return UnitUtil.buildFullyQualifiedUnitPath(iUnit, true, " > ");
    }

    public static boolean isTopLevelUnit(IUnit iUnit) {
        return iUnit.getParent() instanceof IArtifact;
    }

    public static String unitFQProperty(IUnit iUnit, String string, boolean bl2) {
        return ".parsers." + iUnit.getFormatType() + "." + (bl2 ? "text." : "") + string;
    }

    public static final String textProperty(String string) {
        return "text." + string;
    }

    public static PropertyDefinitionManager createTextPDM(IPropertyDefinitionManager iPropertyDefinitionManager) {
        return new PropertyDefinitionManager(pdmRegionText, iPropertyDefinitionManager);
    }

    public static PropertyManager createTextPM(IUnit iUnit) {
        IPropertyDefinitionManager iPropertyDefinitionManager = iUnit.getPropertyDefinitionManager();
        IPropertyDefinitionManager iPropertyDefinitionManager2 = iPropertyDefinitionManager.getChild(pdmRegionText);
        if (iPropertyDefinitionManager2 == null) {
            throw new RuntimeException();
        }
        return new PropertyManager(iPropertyDefinitionManager2, iUnit.getPropertyManager());
    }

    public static List<IUnit> getUnitsFromPathList(IRuntimeProject iRuntimeProject, List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        String string = list.get(0);
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
            if (!string.equals(iLiveArtifact.getArtifact().getName())) continue;
            UnitUtil.getUnitsFromPathList(iLiveArtifact.getUnits(), list, 1, arrayList);
        }
        return arrayList;
    }

    private static void getUnitsFromPathList(List<? extends IUnit> list, List<String> list2, int n, List<IUnit> list3) {
        if (list2.size() <= n) {
            return;
        }
        String string = list2.get(n);
        for (IUnit iUnit : list) {
            if (!string.equals(iUnit.getName()) && !string.equals(iUnit.getRealName())) continue;
            if (list2.size() == n + 1) {
                list3.add(iUnit);
                continue;
            }
            UnitUtil.getUnitsFromPathList(iUnit.getChildren(), list2, n + 1, list3);
        }
    }
}

