/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.units.PoolEntry;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Ser
public class Pool<T extends PoolEntry>
implements Iterable<T> {
    @SerId(value=1)
    protected String poolname;
    @SerId(value=2)
    protected List<T> list;

    public Pool(String string) {
        this.poolname = string;
        this.list = new ArrayList<T>();
    }

    public Pool(String string, int n) {
        this.poolname = string;
        this.list = new ArrayList<T>(n);
    }

    public String getName() {
        return this.poolname;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(T t) {
        ((PoolEntry)t).setIndex(this.list.size());
        this.list.add(t);
    }

    public T get(int n) {
        return (T)((PoolEntry)this.list.get(n));
    }

    public List<T> getAll() {
        return this.list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return String.format("Pool_%s:%d", this.getName(), this.size());
    }
}

