/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyTypeString;
import java.util.Map;
import java.util.WeakHashMap;

public final class PropertyTypeString
implements IPropertyTypeString {
    private static Map<PropertyTypeString, PropertyTypeString> map = new WeakHashMap<PropertyTypeString, PropertyTypeString>();
    private int min;
    private int max;
    private String def;

    public static PropertyTypeString create(int n, int n2, String string) {
        if (string == null) {
            throw new RuntimeException("Default value cannot be null");
        }
        if (string.length() < n || string.length() > n2) {
            throw new IllegalArgumentException("Default value is out of range");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("The range is invalid");
        }
        PropertyTypeString propertyTypeString = new PropertyTypeString(n, n2, string);
        PropertyTypeString propertyTypeString2 = map.get(propertyTypeString);
        if (propertyTypeString2 == null) {
            propertyTypeString2 = propertyTypeString;
            map.put(propertyTypeString2, propertyTypeString);
        }
        return propertyTypeString2;
    }

    public static PropertyTypeString create(String string) {
        return PropertyTypeString.create(0, Integer.MAX_VALUE, string);
    }

    public static PropertyTypeString create() {
        return PropertyTypeString.create(0, Integer.MAX_VALUE, "");
    }

    private PropertyTypeString(int n, int n2, String string) {
        this.min = n;
        this.max = n2;
        this.def = string;
    }

    @Override
    public String getName() {
        return "String";
    }

    @Override
    public int getMinLength() {
        return this.min;
    }

    @Override
    public int getMaxLength() {
        return this.max;
    }

    @Override
    public String getDefault() {
        return this.def;
    }

    @Override
    public boolean validate(Object object) {
        String string = object.toString();
        return string.length() >= this.min && string.length() <= this.max;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.def == null ? 0 : this.def.hashCode());
        n2 = 31 * n2 + this.max;
        n2 = 31 * n2 + this.min;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyTypeString propertyTypeString = (PropertyTypeString)object;
        if (this.def == null ? propertyTypeString.def != null : !this.def.equals(propertyTypeString.def)) {
            return false;
        }
        if (this.max != propertyTypeString.max) {
            return false;
        }
        return this.min == propertyTypeString.min;
    }

    public String toString() {
        return this.getName() + "(\"" + this.getDefault() + "\")";
    }
}

