/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyType;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinition;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PropertyDefinitionManager
implements IPropertyDefinitionManager {
    private static final ILogger logger = GlobalLog.getLogger(PropertyDefinitionManager.class);
    private String region;
    private IPropertyDefinitionManager parent;
    private Map<String, IPropertyDefinitionManager> children = new LinkedHashMap<String, IPropertyDefinitionManager>();
    private Map<String, IPropertyDefinition> definitions = new LinkedHashMap<String, IPropertyDefinition>();

    public PropertyDefinitionManager(String string, IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (string != null && !this.isValidRegionName(string)) {
            throw new IllegalArgumentException(string + " is an invalid region name: it must be a valid Java identifier name");
        }
        if (string == null) {
            string = "";
        }
        this.region = string;
        if (iPropertyDefinitionManager != null) {
            this.attachToParent(iPropertyDefinitionManager);
        }
    }

    public PropertyDefinitionManager(String string) {
        this(string, null);
    }

    public PropertyDefinitionManager() {
        this(null, null);
    }

    @Override
    public void attachToParent(IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (iPropertyDefinitionManager == null || iPropertyDefinitionManager == this) {
            throw new IllegalArgumentException("Invalid parent");
        }
        if (this.parent != null) {
            throw new IllegalStateException("PDM already has a parent");
        }
        if (this.region == null) {
            throw new IllegalStateException("A root PDM cannot have a parent");
        }
        if (!iPropertyDefinitionManager.registerChild(this)) {
            throw new RuntimeException("Could not be registered as a child of the provided parent");
        }
        this.parent = iPropertyDefinitionManager;
    }

    @Override
    public boolean registerChild(IPropertyDefinitionManager iPropertyDefinitionManager) {
        if (this.children.containsKey(iPropertyDefinitionManager.getRegion())) {
            return false;
        }
        this.children.put(iPropertyDefinitionManager.getRegion(), iPropertyDefinitionManager);
        return true;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public boolean isRoot() {
        return this.region.length() == 0;
    }

    @Override
    public IPropertyDefinitionManager getParent() {
        return this.parent;
    }

    @Override
    public String getNamespace() {
        if (this.parent == null) {
            if (this.region.isEmpty()) {
                return this.region;
            }
            return "." + this.region;
        }
        return this.parent.getNamespace() + "." + this.region;
    }

    @Override
    public List<IPropertyDefinitionManager> getChildren() {
        return new ArrayList<IPropertyDefinitionManager>(this.children.values());
    }

    @Override
    public IPropertyDefinitionManager getChild(String string) {
        return this.children.get(string);
    }

    @Override
    public IPropertyDefinition getDefinition(String string) {
        return this.definitions.get(string);
    }

    @Override
    public List<IPropertyDefinition> getDefinitions() {
        return new ArrayList<IPropertyDefinition>(this.definitions.values());
    }

    @Override
    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2) {
        return this.addDefinition(string, iPropertyType, string2, 0, true);
    }

    @Override
    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2, int n) {
        return this.addDefinition(string, iPropertyType, string2, n, true);
    }

    @Override
    public IPropertyDefinition addInternalDefinition(String string, IPropertyType iPropertyType) {
        return this.addDefinition(string, iPropertyType, -1, 1, true);
    }

    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, int n, int n2, boolean bl2) {
        if (this.definitions.containsKey(string = this.simplifyName(string)) && !bl2) {
            throw new RuntimeException("A property definition with that name already exists.");
        }
        if (!this.isValidPropertyName(string)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        PropertyDefinition propertyDefinition = new PropertyDefinition(this, string, n, iPropertyType, n2);
        this.definitions.put(string, propertyDefinition);
        return propertyDefinition;
    }

    public IPropertyDefinition addDefinition(String string, IPropertyType iPropertyType, String string2, int n, boolean bl2) {
        IPropertyDefinition iPropertyDefinition = this.definitions.get(string = this.simplifyName(string));
        if (iPropertyDefinition != null && !bl2) {
            throw new RuntimeException("A property definition with that name already exists.");
        }
        if (!this.isValidPropertyName(string)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (string2 == null && iPropertyDefinition != null) {
            string2 = iPropertyDefinition.getDescription();
        }
        PropertyDefinition propertyDefinition = new PropertyDefinition(this, string, string2, iPropertyType, n);
        this.definitions.put(string, propertyDefinition);
        return propertyDefinition;
    }

    private String simplifyName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n + 1);
        String string3 = this.getNamespace() + '.' + string2;
        if (!string.equals(string3)) {
            String string4 = String.format("Inconsistent fully-qualified name for property definition: %s (expected: %s)", string, string3);
            logger.warn(string4, new Object[0]);
        }
        return string2;
    }

    @Override
    public void removeDefinition(String string) {
        throw new RuntimeException("Not implemented");
    }

    private boolean isValidRegionName(String string) {
        if (string.length() <= 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int j = 1; j < string.length(); ++j) {
            if (Character.isJavaIdentifierPart(string.charAt(j))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidPropertyName(String string) {
        if (string.length() <= 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int j = 1; j < string.length(); ++j) {
            if (Character.isJavaIdentifierPart(string.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("PDM:%s:%d", Strings.safe2(this.region, "<root>"), this.children.size());
    }
}

