/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

@SerDisabled
public class AsciiDocument
extends AbstractTextDocument {
    private static final ILogger logger = GlobalLog.getLogger(AsciiDocument.class);
    private IInput input;
    private List<Long> lineStarts;
    private long anchorRange;
    private long totalSize;

    public AsciiDocument(IInput iInput) {
        this.input = iInput;
        this.lineStarts = new ArrayList<Long>();
        this.lineStarts.add(0L);
        long l2 = 0L;
        try (InputStream inputStream = iInput.getStream();){
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                for (int j = 0; j < n; ++j) {
                    byte by2 = byArray[j];
                    if (by2 != 10 && (by2 != 13 || j + 1 < n && byArray[j + 1] == 10)) continue;
                    this.lineStarts.add(l2 + (long)j + 1L);
                }
                l2 += (long)n;
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
        this.anchorRange = this.lineStarts.size();
        this.totalSize = l2;
    }

    @Override
    public long getAnchorCount() {
        return this.anchorRange;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n, int n2) {
        long l3;
        if (l2 > Integer.MAX_VALUE) {
            throw new RuntimeException("");
        }
        int n3 = (int)l2 - n2;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((l3 = l2 + (long)n) > this.anchorRange) {
            l3 = this.anchorRange;
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(81920);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if ((long)n3 < l3) {
            try (SeekableByteChannel seekableByteChannel = this.input.getChannel();){
                seekableByteChannel.position(this.lineStarts.get(n3));
                while ((long)n3 < l3) {
                    int n4;
                    long l4 = this.lineStarts.get(n3);
                    long l5 = n3 + 1 >= this.lineStarts.size() ? this.totalSize : this.lineStarts.get(n3 + 1);
                    int n5 = (int)(l5 - l4);
                    if (n5 < 0) {
                        break;
                    }
                    if (n5 > byteBuffer.capacity()) {
                        n4 = (n5 & 0xFFFFF000) + 4096;
                        byteBuffer = ByteBuffer.allocate(n4);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    byteBuffer.position(0);
                    byteBuffer.limit(n5);
                    n4 = seekableByteChannel.read(byteBuffer);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int j = 0; j < n4; ++j) {
                        byte by2 = byteBuffer.get(j);
                        if (by2 <= 126 && (by2 >= 32 || by2 == 9)) {
                            stringBuilder.append((char)by2);
                            continue;
                        }
                        if (by2 == 10 || by2 == 13) break;
                        stringBuilder.append(String.format("\\x%02X", by2 & 0xFF));
                    }
                    arrayList2.add(new Anchor(n3, arrayList.size()));
                    arrayList.add(new Line(stringBuilder));
                    ++n3;
                }
            }
            catch (IOException iOException) {
                logger.catching(iOException);
            }
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        return String.format("@%d,%d", iCoordinates.getAnchorId() + 1L, iCoordinates.getColumnOffset() + 1);
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        if (string == null || string.isEmpty() || string.charAt(0) != '@') {
            return null;
        }
        String[] stringArray = string.substring(1).split(",");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            long l2 = Long.parseLong(stringArray[0]);
            int n = Integer.parseInt(stringArray[1]);
            return new Coordinates(l2 - 1L, 0, n - 1);
        }
        catch (NumberFormatException numberFormatException) {
            logger.catching(numberFormatException);
            return null;
        }
    }
}

