/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.table.impl;

import com.pnfsoftware.jeb.core.output.table.ICellCoordinates;
import com.pnfsoftware.jeb.core.output.table.ITableDocument;
import com.pnfsoftware.jeb.core.output.table.impl.CellCoordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.ArrayList;
import java.util.List;

@Ser
public abstract class AbstractTableDocument
extends EventSource
implements ITableDocument {
    @Override
    public void dispose() {
    }

    @Override
    public IPropertyManager getPropertyManager() {
        return null;
    }

    @Override
    public String coordinatesToAddress(ICellCoordinates iCellCoordinates) {
        if (iCellCoordinates == null) {
            return null;
        }
        return String.format("%d,%d", iCellCoordinates.getRowIndex(), iCellCoordinates.getColumnIndex());
    }

    @Override
    public ICellCoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        List<Integer> list = AbstractTableDocument.parseIntegerList(string);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return new CellCoordinates(list.get(0), 0);
        }
        if (list.size() == 2) {
            return new CellCoordinates(list.get(0), list.get(1));
        }
        return null;
    }

    static List<Integer> parseIntegerList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : string.split(",")) {
            try {
                int n = Integer.parseInt(string2.trim());
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return arrayList;
    }
}

