/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileDatabase;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseWriter;
import com.pnfsoftware.jeb.core.dao.IFileStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProjectFileStore
implements IFileDatabase {
    private IFileStore fstore;

    public ProjectFileStore(IFileStore iFileStore) {
        this.fstore = iFileStore;
    }

    private String buildStoreKey(String string, int n) {
        return String.format("%s-%03d", string, n);
    }

    @Override
    public boolean hasFile(String string, int n) {
        return this.fstore.has(this.buildStoreKey(string, n));
    }

    @Override
    public boolean saveFile(String string, int n, byte[] byArray) {
        return this.fstore.put(this.buildStoreKey(string, n), byArray) != null;
    }

    @Override
    public byte[] loadFile(String string, int n) {
        return this.fstore.get(this.buildStoreKey(string, n));
    }

    @Override
    public boolean deleteFile(String string, int n) {
        return this.fstore.remove(this.buildStoreKey(string, n));
    }

    @Override
    public OutputStream getFileWriter(String string) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public InputStream getFileReader(String string) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IFileDatabaseWriter getDatabaseWriter(String string) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IFileDatabaseReader getDatabaseReader(String string) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

