/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.DevPluginClassname;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import java.util.ArrayList;
import java.util.List;

public class EnginesPropertiesUtil {
    private IPropertyManager pm;

    public EnginesPropertiesUtil(IPropertyManager iPropertyManager) {
        this.pm = iPropertyManager;
    }

    public List<DevPluginClassname> parseDevPluginClassnames(String string) {
        ArrayList<DevPluginClassname> arrayList = new ArrayList<DevPluginClassname>();
        if (string == null) {
            return arrayList;
        }
        for (String string2 : string.split("[;,]")) {
            boolean bl2;
            String string3;
            String[] stringArray = string2.split(":");
            if (stringArray.length == 1) {
                string3 = stringArray[0].trim();
                bl2 = true;
            } else {
                if (stringArray.length != 2) continue;
                string3 = stringArray[0].trim();
                boolean bl3 = bl2 = Conversion.stringToInt(stringArray[1]) == 1;
            }
            if (string3.isEmpty()) continue;
            arrayList.add(new DevPluginClassname(string3, bl2));
        }
        return arrayList;
    }

    public List<DevPluginClassname> getDevPluginClassnames() {
        String string = this.pm.getString(".DevPluginClassnames");
        return this.parseDevPluginClassnames(string);
    }

    public String buildDevPluginClassnames(List<DevPluginClassname> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (DevPluginClassname devPluginClassname : list) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(String.format("%s:%s", devPluginClassname.getClassname(), devPluginClassname.isEnabled() ? "1" : "0"));
            ++n;
        }
        return stringBuilder.toString();
    }

    public void setDevPluginClassnames(List<DevPluginClassname> list) {
        String string = this.buildDevPluginClassnames(list);
        this.pm.setString(".DevPluginClassnames", string);
    }
}

