/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import java.util.ArrayList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderSymbolsFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private int symbolFlag;
    private DataFrameView dfv;

    public CodeLoaderSymbolsFragment(Composite parent, int style, RcpClientContext context, IRcpUnitView unitView, ICodeObjectUnit co, int symbolFlag, INativeCodeUnit<?> pbcu) {
        super(parent, style, co, unitView, context);
        this.setLayout((Layout)new FillLayout());
        this.symbolFlag = symbolFlag;
        this.dfv = this.buildSimple(this, "Type", "Flags", "Name", "Identifier", "Symbol@", "Address", "Size");
        this.dfv.getContextMenu().addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                CodeLoaderSymbolsFragment.this.addOperationsToContextMenu(menuMgr);
            }
        });
    }

    public ColumnViewer getViewer() {
        return this.dfv.getTableViewer();
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        if ((this.symbolFlag & 2) != 0) {
            long a = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation().getEntryPoint();
            SymbolInformation s = new SymbolInformation(SymbolType.PTRFUNCTION, 2, -1L, "start", 0L, a, 0L);
            this.addSymbolAsRow(df, s);
        }
        for (ISymbolInformation iSymbolInformation : ((ICodeObjectUnit)this.getUnit()).getSymbols()) {
            if ((iSymbolInformation.getFlags() & this.symbolFlag) != this.symbolFlag) continue;
            this.addSymbolAsRow(df, iSymbolInformation);
        }
    }

    private void addSymbolAsRow(DataFrame df, ISymbolInformation s) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(CodeLoaderSymbolsFragment.formatSymbolType(s.getType()));
        row.add(CodeLoaderSymbolsFragment.formatSymbolFlags(s.getFlags()));
        row.add(s.getName());
        row.add(s.getIdentifier());
        row.add(s.getRelativeAddress());
        row.add(s.getSymbolRelativeAddress());
        row.add(s.getSymbolSize());
        df.addRow(row);
    }

    private static String formatSymbolType(SymbolType type) {
        return type == null ? "" : type.toString();
    }

    private static String formatSymbolFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("EXPORT ");
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 1) != 0) {
            sb.append("IMPORT ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("CONTI. ");
            flags &= 0xFFFFFFFB;
        }
        if ((flags & 0x10) != 0) {
            flags &= 0xFFFFFFEF;
        }
        if (flags != 0) {
            sb.append(String.format("(other:%Xh) ", flags));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public IItem getActiveItem() {
        TableItem[] sel = this.dfv.getTable().getSelection();
        if (sel != null && sel.length == 1) {
            return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel[0].getText(2), sel[0].getText(5));
        }
        return null;
    }

    @Override
    public String getActiveAddress() {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return super.getActiveAddress();
    }
}

