/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMethodStackMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WidgetActionWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.InfiniTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractInfiniTableSectionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.InfiniTableViewer;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionDefine;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionDefineArray;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionRename;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionSelectType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionSetType;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorActionUndefine;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class StackEditorView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(StackEditorView.class);
    private Font codefont;
    private INativeCodeUnit<?> unit;
    private INativeMethodItem routine;
    private InfiniTableView view;
    private InfiniTableViewer viewer;
    private StackItemsProvider provider;
    protected Boolean allowUndefine;

    public StackEditorView(final Composite parent, int style, INativeCodeUnit<?> unit) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (unit == null) {
            throw new NullPointerException();
        }
        this.unit = unit;
        ToolBar bar = new ToolBar((Composite)this, 320);
        bar.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        ToolItem item = new ToolItem(bar, 2);
        Button btnHelp = UIUtil.createPushbox((Composite)bar, S.s(365), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = "This widget is the native routine stack editor. The table represents a stack memory layout.\n\nRight click on a row, at the given offset, to perform any of the following actions:\n- Define a field\n- Undefine a field\n- Rename a field\n- Create an array field\n- Set or select the type of a field\n\nYou may scroll up/down to access lower/higher offsets.\n";
                MessageDialog.openInformation(parent.getShell(), "Controls", msg);
            }
        });
        btnHelp.pack();
        item.setWidth(btnHelp.getSize().x);
        item.setControl((Control)btnHelp);
        bar.pack();
        this.view = new InfiniTableView(this, 4, new String[]{"Offset", "Size", "Name", "Type", "Comment"});
        this.view.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.viewer = new InfiniTableViewer(this.view);
        this.provider = new StackItemsProvider();
        this.viewer.setContentProvider(this.provider);
        this.viewer.setLabelProvider(new StackItemLabelProvider(this.provider));
        this.viewer.setTopId(0L, false);
        this.viewer.setInput(null);
        WidgetActionWrapper actionWrapper = new WidgetActionWrapper((Control)this.view.getTable());
        actionWrapper.registerAction(new StackEditorActionDefine(this));
        actionWrapper.registerAction(new StackEditorActionUndefine(this));
        actionWrapper.registerAction(new StackEditorActionRename(this));
        actionWrapper.registerAction(new StackEditorActionDefineArray(this));
        actionWrapper.registerAction(new StackEditorActionSetType(this));
        actionWrapper.registerAction(new StackEditorActionSelectType(this));
    }

    public INativeCodeUnit<?> getInputUnit() {
        return this.unit;
    }

    public INativeMethodItem getInputRoutine() {
        return this.routine;
    }

    public void setInputRoutine(INativeMethodItem routine) {
        this.routine = routine;
        this.viewer.setInput(routine);
    }

    public void setCodefont(Font codefont) {
        this.codefont = codefont;
    }

    void refresh() {
        int index0 = this.view.getTable().getSelectionIndex();
        this.viewer.refresh();
        IStructuredSelection sel1 = (IStructuredSelection)this.viewer.getSelection();
        if (sel1.isEmpty()) {
            this.view.getTable().setSelection(index0);
        }
    }

    public ItemEntry getSelectedEntry() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : (ItemEntry)sel.getFirstElement();
    }

    class StackItemsProvider
    extends AbstractInfiniTableSectionProvider {
        StackItemsProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            StackEditorView.this.routine = (INativeMethodItem)newInput;
        }

        @Override
        public Object[] getRowElements(Object row) {
            ItemEntry e = (ItemEntry)row;
            return new Object[]{e.offset, e.size, e.name, e.type, e.comment};
        }

        @Override
        public Object[] get(Object inputElement, long id, int cnt) {
            Assert.a(StackEditorView.this.routine == (INativeMethodItem)inputElement);
            return this.readSlots(StackEditorView.this.unit, StackEditorView.this.routine, id, cnt);
        }

        private INativeContinuousItem createGapItem(IMemoryModel model, long address, int size) {
            INativeContinuousItem item = model.getGapFactory().create(address, address + (long)size);
            item.setName("undefined");
            return item;
        }

        private Object[] readSlots(INativeCodeUnit<?> unit, INativeMethodItem routine, long id, int cnt) {
            int i0;
            INativeMethodDataItem routineData = routine.getData();
            IMethodStackMemoryModel stk = routineData.getStackframeModel();
            int indexZero = -1;
            ArrayList<INativeContinuousItem> list = new ArrayList<INativeContinuousItem>();
            HashSet<Long> slackset = new HashSet<Long>();
            if (!stk.isEmpty()) {
                INativeContinuousItem item;
                Long lastAddress = null;
                SortedMap<Long, INativeContinuousItem> view_ = stk.getView(null, null);
                TreeMap<Long, INativeContinuousItem> view = new TreeMap<Long, INativeContinuousItem>(view_);
                for (Long address : view.descendingKeySet()) {
                    INativeContinuousItem item2 = view.get(address);
                    if (lastAddress != null && lastAddress != item2.getEnd()) {
                        for (long a = lastAddress - 1L; a >= (Long)item2.getEnd(); --a) {
                            list.add(this.createGapItem(stk, a, 1));
                        }
                    }
                    list.add(item2);
                    lastAddress = (Long)item2.getBegin();
                }
                INativeContinuousItem slot = (INativeContinuousItem)list.get(0);
                long first = Math.max(0L, (Long)slot.getEnd() + (long)(cnt * 1));
                ArrayList<INativeContinuousItem> tmplist = new ArrayList<INativeContinuousItem>();
                for (long a = first - 1L; a >= (Long)slot.getEnd(); --a) {
                    tmplist.add(this.createGapItem(stk, a, 1));
                    slackset.add(a);
                }
                list.addAll(0, tmplist);
                slot = (INativeContinuousItem)list.get(list.size() - 1);
                long last = Math.min(0L, (Long)slot.getBegin() - (long)(cnt * 1));
                for (long a = (Long)slot.getBegin() - 1L; a >= last; --a) {
                    list.add(this.createGapItem(stk, a, 1));
                    slackset.add(a);
                }
                indexZero = -1;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && ((Long)(item = (INativeContinuousItem)iterator.next()).getBegin() > 0L || (Long)item.getEnd() <= 0L)) {
                    ++indexZero;
                }
            }
            if (indexZero < 0 || id + (long)indexZero < 0L || id + (long)indexZero + (long)cnt > (long)list.size()) {
                list.clear();
                for (long a = id; a < id + (long)cnt; ++a) {
                    INativeContinuousItem item = this.createGapItem(stk, -a, 1);
                    list.add(item);
                    slackset.add(-a);
                }
                indexZero = (int)(-id);
            }
            ArrayList<ItemEntry> r = new ArrayList<ItemEntry>();
            for (int i = i0 = (int)(id + (long)indexZero); i < i0 + cnt; ++i) {
                INativeContinuousItem item = (INativeContinuousItem)list.get(i);
                ItemEntry e = new ItemEntry();
                e.offset = (int)item.getMemoryAddress();
                e.name = item.getName(true);
                e.size = (int)item.getMemorySize();
                e.type = item instanceof INativeDataItem ? ((INativeDataItem)item).getType() : null;
                e.comment = stk.getCommentManager().getComment(e.offset);
                e.slack = slackset.contains(e.offset);
                r.add(e);
            }
            return r.toArray();
        }
    }

    class StackItemLabelProvider
    extends DefaultCellLabelProvider {
        public StackItemLabelProvider(StackItemsProvider provider) {
            super(provider);
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            if (StackEditorView.this.codefont != null && (cell.getColumnIndex() == 0 || cell.getColumnIndex() == 1)) {
                cell.setFont(StackEditorView.this.codefont);
            }
            ItemEntry entry = (ItemEntry)cell.getElement();
            if (!entry.slack && ThemeManager.getInstance().isStandardTheme()) {
                int rgb = entry.type != null ? 0xFFFFB0 : 0xFFFFE0;
                cell.setBackground(UIAssetManager.getInstance().getColor(rgb));
            }
        }

        @Override
        public String getStringAt(Object element, int key) {
            ItemEntry e = (ItemEntry)element;
            switch (key) {
                case 0: {
                    if (e.offset >= 0) {
                        return String.format("+%08X", e.offset);
                    }
                    return String.format("-%08X", -e.offset);
                }
                case 1: {
                    return String.format("%04X", e.size);
                }
                case 3: {
                    if (e.type == null) break;
                    return e.type.getSignature(true);
                }
            }
            return super.getStringAt(element, key);
        }
    }
}

