/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorView;
import com.pnfsoftware.jeb.util.encoding.Conversion;

public class StackEditorActionDefineArray
extends StackEditorAction {
    public StackEditorActionDefineArray(StackEditorView v) {
        super("Array", v);
        this.keyCode = 97;
        this.setAccelerator(65);
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedItem() != null;
    }

    @Override
    public void run() {
        int cnt;
        INativeType itemType;
        INativeDataItem item = this.getSelectedItem();
        ITypeManager typeman = this.v.getInputUnit().getTypeManager();
        int requestedOffset = (int)item.getMemoryAddress();
        INativeType eltType = itemType = item.getType();
        if (itemType instanceof IArrayType) {
            eltType = ((IArrayType)itemType).getElementType();
        }
        int maxEltNoUndefine = -1;
        INativeContinuousItem item1 = this.getStackModel().getNextItem(requestedOffset);
        if (item1 != null) {
            maxEltNoUndefine = ((int)item1.getMemoryAddress() - requestedOffset) / eltType.getSize();
        }
        TextDialog dlg = new TextDialog(this.v.getShell(), "Define an Array", "" + maxEltNoUndefine, null);
        dlg.setSelected(true);
        String val = dlg.open();
        if (val != null && (cnt = Conversion.stringToInt(val)) >= 1) {
            if (!this.offerClearItems(requestedOffset, eltType.getSize() * cnt)) {
                return;
            }
            IArrayType newItemType = typeman.createArray(eltType, cnt);
            INativeDataItem newItem = this.getStackManager().defineItem(requestedOffset, newItemType);
            if (newItem == null) {
                UI.error("An error occurred.");
                return;
            }
            this.v.refresh();
        }
    }
}

