/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IMethodStackMemoryModel;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IStackframeManager;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.operations.JebAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StackEditorView;
import java.util.ArrayList;
import java.util.List;

public abstract class StackEditorAction
extends JebAction {
    protected StackEditorView v;

    public StackEditorAction(String name, StackEditorView v) {
        super(null, name);
        this.v = v;
        this.isContextual = true;
    }

    IStackframeManager getStackManager() {
        return this.v.getInputRoutine().getData().getStackframeManager();
    }

    IMemoryModel getStackModel() {
        return this.v.getInputRoutine().getData().getStackframeModel();
    }

    protected INativeDataItem getSelectedItem() {
        INativeContinuousItem item;
        ItemEntry e = this.v.getSelectedEntry();
        if (e != null && (item = this.getStackModel().getItemAt(e.offset)) instanceof INativeDataItem) {
            return (INativeDataItem)item;
        }
        return null;
    }

    protected List<INativeContinuousItem> collectItemsToBeUndefined(int startOffset, int wantedSize) {
        return StackEditorAction.collectItemsToBeUndefined(this.v.getInputRoutine(), startOffset, wantedSize);
    }

    static List<INativeContinuousItem> collectItemsToBeUndefined(INativeMethodItem routine, int startOffset, int wantedSize) {
        IMethodStackMemoryModel model = routine.getData().getStackframeModel();
        return new ArrayList<INativeContinuousItem>(model.getItemsInRange(startOffset, true, startOffset + wantedSize, true).values());
    }

    protected boolean undefineItems(List<INativeContinuousItem> items) {
        return StackEditorAction.undefineItems(this.v.getInputRoutine(), items);
    }

    static boolean undefineItems(INativeMethodItem routine, List<INativeContinuousItem> items) {
        IStackframeManager manager = routine.getData().getStackframeManager();
        for (INativeContinuousItem item : items) {
            if (manager.undefineItem(item.getMemoryAddress())) continue;
            return false;
        }
        return true;
    }

    protected boolean offerClearItems(int offset, int size) {
        return StackEditorAction.offerClearItems(this.v, this.v.getInputRoutine(), offset, size);
    }

    static boolean offerClearItems(StackEditorView v, INativeMethodItem routine, int offset, int size) {
        List<INativeContinuousItem> r = StackEditorAction.collectItemsToBeUndefined(routine, offset, size);
        if (r.size() > 1) {
            boolean allowUndefine;
            if (v != null && v.allowUndefine != null) {
                allowUndefine = v.allowUndefine;
            } else {
                String msg = String.format("This action will undefine %d fields. Proceed?", r.size() - 1);
                AdaptivePopupDialog dlg2 = AdaptivePopupDialog.question(UI.getShellTracker().get(), S.s(207), msg);
                boolean bl = allowUndefine = dlg2.open() == 1;
                if (dlg2.isDoNotShow() && v != null) {
                    v.allowUndefine = allowUndefine;
                }
            }
            if (!allowUndefine) {
                return false;
            }
        }
        if (!StackEditorAction.undefineItems(routine, r)) {
            UI.error("An error occurred while undefining fields.");
            return false;
        }
        return true;
    }
}

