/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.util.regex.ILabelValueProvider;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NativeTypesFragment
extends AbstractFilteredTableFragment<INativeCodeUnit<?>, INativeType> {
    private static final ILogger logger = GlobalLog.getLogger(NativeTypesFragment.class);
    Combo comboSource;
    FilteredTableViewer viewer;

    public NativeTypesFragment(Composite parent, int style, RcpClientContext context, final INativeCodeUnit<?> pbcu, IRcpUnitView unitView, int initialTypesource) {
        super(parent, style, pbcu, unitView, context, new ContentProvider(pbcu, initialTypesource));
        this.setLayout((Layout)new GridLayout(1, false));
        ToolBar bar = new ToolBar((Composite)this, 320);
        bar.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        ToolItem item = new ToolItem(bar, 2);
        Label label = new Label((Composite)bar, 0);
        label.setText("Source: ");
        label.pack();
        item.setWidth(label.getSize().x);
        item.setControl((Control)label);
        item = new ToolItem(bar, 2);
        this.comboSource = new Combo((Composite)bar, 2056);
        this.comboSource.add("In-use types");
        this.comboSource.add("All types");
        this.comboSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NativeTypesFragment.this.comboSource.getSelectionIndex();
                ((ContentProvider)NativeTypesFragment.this.getProvider()).setTypeSource(NativeTypesFragment.this.getTypeSourceFromIndex(index));
                NativeTypesFragment.this.viewer.setInput(pbcu);
            }
        });
        this.comboSource.pack();
        item.setWidth(this.comboSource.getSize().x);
        item.setControl((Control)this.comboSource);
        this.updateTypeSourceWidget(initialTypesource);
        bar.pack();
        String[] columnNames = new String[]{S.s(738)};
        this.setLabelProvider(new LabelProvider());
        this.viewer = this.buildFilteredViewer(this, columnNames, false);
        this.layout();
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setLayoutData(UIUtil.createGridDataFill(true, true));
    }

    public int getTypeSourceFromIndex(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public void updateTypeSourceWidget(int typesource) {
        int index = -1;
        if (typesource == 1) {
            index = 0;
        } else if (typesource == 3) {
            index = 1;
        }
        if (index >= 0) {
            this.comboSource.select(index);
        } else {
            this.comboSource.clearSelection();
        }
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof INativeType;
    }

    @Override
    public INativeType getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof INativeType)) {
            return null;
        }
        return (INativeType)row;
    }

    static class LabelProvider
    implements ILabelValueProvider,
    ITableLabelProvider {
        LabelProvider() {
        }

        @Override
        public void addListener(ILabelProviderListener listener) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener listener) {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            INativeType t = (INativeType)element;
            if (columnIndex == 0) {
                return t == null ? "" : t.getSignature(true);
            }
            throw new RuntimeException();
        }

        @Override
        public String getString(Object element) {
            return this.getColumnText(element, 0);
        }

        @Override
        public String getStringAt(Object element, int key) {
            return this.getColumnText(element, key);
        }
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        IEventListener listener;
        INativeCodeUnit<?> pbcu;
        int typesource;
        ViewerRefresher refresher;

        public ContentProvider(INativeCodeUnit<?> pbcu, int initialTypesource) {
            this.pbcu = pbcu;
            this.typesource = initialTypesource;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((INativeCodeUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            if (this.refresher == null) {
                this.refresher = new ViewerRefresher(viewer.getControl().getDisplay(), viewer);
            }
            this.pbcu = (INativeCodeUnit)newInput;
            if (this.pbcu == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    if (pbcu != null) {
                        refresher.request();
                    }
                }
            };
            this.pbcu.addListener(this.listener);
        }

        public void setTypeSource(int typesource) {
            this.typesource = typesource;
        }

        public int getTypeSource() {
            return this.typesource;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List<INativeType> types = TypeUtil.retrieveAvailableTypes(this.pbcu, this.typesource);
            return types.toArray();
        }

        @Override
        public Object[] getRowElements(Object row) {
            INativeType e = (INativeType)row;
            return new Object[]{e.getSignature(true)};
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }
}

