/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.anno.AnnotationService;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.anno.TextAnnotation;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import java.util.ArrayList;
import java.util.List;

public class UnitTextAnnotator
implements IEventListener {
    UIState uiState;
    ITextDocumentViewer viewer;

    public UnitTextAnnotator(UIState uiState, ITextDocumentViewer viewer) {
        this.uiState = uiState;
        this.viewer = viewer;
        uiState.addListener(this);
    }

    public void dispose() {
        this.uiState.removeListener(this);
    }

    @Override
    public void onEvent(IEvent e) {
        this.viewer.unregisterAnnotations();
        for (String address : this.uiState.getBreakpoints().keySet()) {
            ICoordinates coord = this.getLastCoordForAddress(address);
            if (coord == null) continue;
            String annoType = null;
            annoType = this.uiState.isBreakpointEnabled(address) ? "com.pnfsoftware.jeb.rcpclient.textAnno.dbgBP" : "com.pnfsoftware.jeb.rcpclient.textAnno.dbgBPDisabled";
            TextAnnotation anno = AnnotationService.getInstance().getFactory(annoType).create(coord);
            this.viewer.registerAnnotation(anno);
        }
        String pcAddress = this.uiState.getProgramCounter();
        if (pcAddress != null) {
            for (ICoordinates coord : this.getCoordsForAddress(pcAddress)) {
                this.viewer.registerAnnotation(AnnotationService.getInstance().getFactory("com.pnfsoftware.jeb.rcpclient.textAnno.dbgPC").create(coord));
            }
        }
    }

    List<ICoordinates> getCoordsForAddress(String address, int maxcnt) {
        ArrayList<ICoordinates> r = new ArrayList<ICoordinates>();
        ICoordinates coord = this.viewer.getDocument().addressToCoordinates(address);
        if (coord != null) {
            int cnt = 0;
            while (cnt++ < maxcnt) {
                r.add(coord);
                coord = new Coordinates(coord.getAnchorId(), coord.getLineDelta() + 1, coord.getColumnOffset());
                String a2 = this.viewer.getDocument().coordinatesToAddress(coord);
                if (address.equals(a2)) continue;
                break;
            }
        }
        return r;
    }

    List<ICoordinates> getCoordsForAddress(String address) {
        return this.getCoordsForAddress(address, 20);
    }

    ICoordinates getFirstCoordForAddress(String address) {
        return this.viewer.getDocument().addressToCoordinates(address);
    }

    ICoordinates getLastCoordForAddress(String address) {
        List<ICoordinates> r = this.getCoordsForAddress(address, 50);
        if (r.isEmpty()) {
            return null;
        }
        return r.get(r.size() - 1);
    }
}

