/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.google.common.net.MediaType;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.client.events.JC;
import com.pnfsoftware.jeb.client.events.JebClientEvent;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.table.ITableDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.AsciiDocument;
import com.pnfsoftware.jeb.core.output.text.impl.HexDumpDocument;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilationTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IPECOFFUnit;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.UnitPropertiesDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.AbstractRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.ActionEx;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabContextMenuManager;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabFolderView;
import com.pnfsoftware.jeb.rcpclient.parts.AbstractPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.DecompiledViewNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectTreeLabelProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.BinaryDataFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.DescriptionFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.ImageFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.Position;
import com.pnfsoftware.jeb.rcpclient.parts.units.TableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TreeFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeHierarchyFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.NativeTypesFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ReferencedMethodsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StringsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderInfoFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderSegmentsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderSymbolsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgBreakpointsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgCodeFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgLogFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgStackFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgThreadsFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.debuggers.DbgVariablesFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.DalvikCallgraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.DalvikCodeGraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NativeCallgraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NativeCodeGraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.StaticCodeGraphFragment;
import com.pnfsoftware.jeb.rcpclient.util.Extensions;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class UnitPartManager
extends AbstractPartManager
implements IRcpUnitView {
    private static final ILogger logger = GlobalLog.getLogger(UnitPartManager.class, Integer.MAX_VALUE);
    private Display display;
    private AbstractRefresher refresher1;
    private AbstractRefresher refresher2;
    private Composite parent;
    private TabFolderView tabman;
    private IUnit unit;
    private List<String> fragmentList;
    private List<String> fragmentBlacklist;
    private IEventListener unitListener;
    private IUnitFormatter unitFormatter;
    private AbstractTextDocument rawDoc;

    public UnitPartManager(RcpClientContext context) {
        super(context);
    }

    @Override
    public IUnit getUnit() {
        return this.unit;
    }

    public boolean isActive() {
        return this.unit != null;
    }

    public boolean isInactive() {
        return this.unit == null;
    }

    @Override
    public String getLabel() {
        if (this.isUninitialized()) {
            return null;
        }
        return this.part.getLabel();
    }

    @Override
    public void setLabel(String label) {
        if (this.isUninitialized()) {
            return;
        }
        this.part.setLabel(label);
    }

    @Override
    public void createView(Composite parent, IMPart part) {
        logger.i("Constructing unit part... part=%s", part);
        this.parent = parent;
        this.part = part;
        this.display = parent.getDisplay();
        this.refresher1 = new AbstractRefresher(this.display, "UnitPartName"){

            @Override
            protected void performRefresh() {
                if (UnitPartManager.this.unit != null) {
                    UnitPartManager.this.updatePartName();
                }
            }
        };
        this.refresher2 = new AbstractRefresher(this.display, "UnitPartTabs"){

            @Override
            protected void performRefresh() {
                if (UnitPartManager.this.unit != null) {
                    UnitPartManager.this.addUnitDocuments(UnitPartManager.this.tabman.getContainer());
                }
            }
        };
        parent.setLayout((Layout)new FillLayout());
        boolean lazyInit = !this.context.getPropertyManager().getBoolean(".ui.AlwaysLoadFragments");
        this.tabman = new TabFolderView(parent, 3074, false, lazyInit);
        new TabContextMenuManager(this.tabman.getContainer()){

            @Override
            public void addActions(final CTabItem selectedItem, IMenuManager menuMgr) {
                menuMgr.add(new ActionEx(null, "Pull Out"){

                    @Override
                    public boolean isEnabled() {
                        return selectedItem != null && UnitPartManager.this.tabman.getEntryVisibleCount() >= 2;
                    }

                    @Override
                    public void run() {
                        logger.i("Pulling out the fragment (tab) into its own part (view)", new Object[0]);
                        Control fragment = selectedItem.getControl();
                        UnitPartManager.this.tabman.removeEntry(fragment);
                        UnitPartManager.this.context.getPartManager().createSingle(UnitPartManager.this.unit, fragment.getClass());
                    }
                });
            }
        }.bind();
        this.setup();
    }

    public void setup() {
        INativeDecompilationTarget target;
        INativeSourceUnit srcUnit;
        List<INativeDecompilationTarget> targets;
        Control focusedDocument;
        if (this.part == null) {
            return;
        }
        this.unit = (IUnit)this.part.getData().get("unit");
        this.fragmentList = (List)this.part.getData().get("fragmentList");
        this.fragmentBlacklist = (List)this.part.getData().get("fragmentBlacklist");
        if (this.unit == null) {
            return;
        }
        if (!this.unit.isProcessed()) {
            String message = String.format("%s.\n\n%s", S.s(790), S.s(662));
            boolean r = MessageDialog.openQuestion(this.parent.getShell(), S.s(821), message);
            if (!r) {
                return;
            }
        }
        logger.i("Building a part for unit: %s", this.unit);
        this.unitFormatter = this.unit.getFormatter();
        if (this.unitFormatter == null) {
            throw new JebRuntimeException(Strings.f("Formatter is null for %s", this.unit));
        }
        CTabFolder folder = this.tabman.getContainer();
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (e.getType() == J.UnitPropertyChanged) {
                    UnitPartManager.this.refresher1.request();
                } else if (e.getType() == J.UnitChange) {
                    UnitPartManager.this.refresher2.request();
                }
            }
        };
        this.unit.addListener(this.unitListener);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UnitPartManager.this.updatePartName();
                UnitPartManager.this.context.refreshHandlersStates();
            }
        });
        Object focusedControl = null;
        if (this.shouldDisplay(DescriptionFragment.class)) {
            this.tabman.addEntry(S.s(268), (Control)new DescriptionFragment((Composite)folder, 0, this.context, this.unit));
        }
        if (this.unit instanceof IBinaryUnit) {
            MediaType mt;
            IInput input;
            if ((this.shouldDisplay(TextFragment.class) || this.shouldDisplay(BinaryDataFragment.class)) && (input = ((IBinaryUnit)this.unit).getInput()).getCurrentSize() >= 0L) {
                this.rawDoc = null;
                String unitName = this.unit.getName();
                if (this.shouldDisplay(TextFragment.class) && (!Extensions.hasExtension(unitName) || Extensions.hasKnownTextDocumentExtension(unitName))) {
                    long size = input.getCurrentSize();
                    int minExpectedAsciiSize = (int)Math.min(size, 30L);
                    byte[] headerBytes = new byte[minExpectedAsciiSize];
                    ByteBuffer buffer = input.getHeader();
                    if (buffer != null) {
                        buffer.get(headerBytes);
                    }
                    if (Strings.getAsciiLength(headerBytes, minExpectedAsciiSize) == minExpectedAsciiSize) {
                        this.rawDoc = new AsciiDocument(input);
                        TextFragment textdump = new TextFragment((Composite)folder, 0, this.context, this.unit, this, (ITextDocument)this.rawDoc);
                        this.tabman.addEntry(S.s(769), (Control)textdump);
                        focusedControl = textdump;
                    }
                }
                if (this.shouldDisplay(BinaryDataFragment.class) && this.rawDoc == null) {
                    this.rawDoc = new HexDumpDocument(input, this.unit);
                    BinaryDataFragment hexdump = new BinaryDataFragment((Composite)folder, 0, this.context, this.unit, this, (HexDumpDocument)this.rawDoc);
                    this.tabman.addEntry(S.s(366), (Control)hexdump);
                    hexdump.setFocusPriority(0);
                    focusedControl = hexdump;
                }
            }
            if (this.shouldDisplay(ImageFragment.class) && (mt = UnitPartManager.getMediaTypeForUnit(this.unit)).is(MediaType.ANY_IMAGE_TYPE)) {
                ImageFragment img = new ImageFragment((Composite)folder, 0, this.context, (IBinaryUnit)this.unit);
                this.tabman.addEntry(S.s(378), (Control)img);
                focusedControl = img;
            }
        }
        if ((focusedDocument = this.addUnitDocuments(folder)) != null) {
            focusedControl = focusedDocument;
        }
        if (this.unit instanceof ICodeObjectUnit) {
            String label;
            ICodeObjectUnit co = (ICodeObjectUnit)this.unit;
            if (this.shouldDisplay(CodeLoaderInfoFragment.class) && co.getLoaderInformation() != null) {
                CodeLoaderInfoFragment infoview = new CodeLoaderInfoFragment((Composite)folder, 0, this.context, co);
                this.tabman.addEntry(S.s(625), (Control)infoview);
                focusedControl = infoview;
                new AddressNavigator(this.context, infoview.getViewer(), infoview, this.unit);
            }
            if (this.shouldDisplay(CodeLoaderSegmentsFragment.class) && co.getSegments() != null) {
                CodeLoaderSegmentsFragment segview = new CodeLoaderSegmentsFragment((Composite)folder, 0, this.context, co, true);
                label = this.unit instanceof IPECOFFUnit ? S.s(718) : S.s(720);
                this.tabman.addEntry(label, (Control)segview);
                new AddressNavigator(this.context, segview.getViewer(), segview, this.unit);
            }
            if (this.shouldDisplay(CodeLoaderSegmentsFragment.class) && co.getSections() != null) {
                CodeLoaderSegmentsFragment sectview = new CodeLoaderSegmentsFragment((Composite)folder, 0, this.context, co, false);
                label = this.unit instanceof IPECOFFUnit ? "Directory Entries" : S.s(718);
                this.tabman.addEntry(label, (Control)sectview);
                new AddressNavigator(this.context, sectview.getViewer(), sectview, this.unit);
            }
            if (this.shouldDisplay(CodeLoaderSymbolsFragment.class) && co.getSymbols() != null) {
                CodeLoaderSymbolsFragment symbolsView = new CodeLoaderSymbolsFragment((Composite)folder, 0, this.context, this, co, 0, null);
                this.tabman.addEntry(S.s(762), (Control)symbolsView);
                new AddressNavigator(this.context, symbolsView.getViewer(), symbolsView, this.unit);
            }
        }
        if (this.unit instanceof ICodeUnit) {
            AbstractUnitFragment v;
            if (this.unit instanceof INativeCodeUnit) {
                if (this.shouldDisplay(NativeCodeGraphFragment.class)) {
                    v = new NativeCodeGraphFragment((Composite)folder, 0, this.context, (INativeCodeUnit)this.unit, this);
                    this.tabman.addEntry("Graph", (Control)v);
                }
                if (this.shouldDisplay(NativeCallgraphFragment.class)) {
                    v = new NativeCallgraphFragment((Composite)folder, 0, this.context, (INativeCodeUnit)this.unit, this);
                    this.tabman.addEntry("Callgraph", (Control)v);
                }
            }
            if (this.unit instanceof IDexUnit) {
                if (this.shouldDisplay(DalvikCodeGraphFragment.class)) {
                    v = new DalvikCodeGraphFragment((Composite)folder, 0, this.context, (IDexUnit)this.unit, this);
                    this.tabman.addEntry("Graph", (Control)v);
                }
                if (this.shouldDisplay(DalvikCallgraphFragment.class)) {
                    v = new DalvikCallgraphFragment((Composite)folder, 0, this.context, (IDexUnit)this.unit, this);
                    this.tabman.addEntry("Callgraph", (Control)v);
                }
            }
            if (this.shouldDisplay(CodeHierarchyFragment.class)) {
                CodeHierarchyFragment codeHier = new CodeHierarchyFragment((Composite)folder, 0, this.context, (ICodeUnit)this.unit, null, 256, 65536, false, null);
                this.tabman.addEntry(S.s(369), (Control)codeHier);
                new AddressNavigator(this.context, codeHier.getViewer(), codeHier, this.unit);
                this.wrapCustomFragment(this.unit, (Control)codeHier, "codehier");
            }
            if (this.shouldDisplay(StringsFragment.class)) {
                this.tabman.addEntry(S.s(754), (Control)new StringsFragment((Composite)folder, 0, this.context, (ICodeUnit)this.unit, this));
            }
        }
        if (this.unit instanceof INativeCodeUnit) {
            ICodeObjectUnit co;
            INativeCodeUnit pbcu = (INativeCodeUnit)this.unit;
            if (this.shouldDisplay(NativeTypesFragment.class)) {
                this.tabman.addEntry(S.s(781), (Control)new NativeTypesFragment((Composite)folder, 0, this.context, pbcu, this, 1));
            }
            if (this.shouldDisplay(CodeLoaderSymbolsFragment.class) && pbcu.getCodeObjectContainer() != null && (co = pbcu.getCodeObjectContainer()) != null) {
                CodeLoaderSymbolsFragment impview = new CodeLoaderSymbolsFragment((Composite)folder, 0, this.context, this, co, 1, pbcu);
                this.tabman.addEntry(S.s(381), (Control)impview);
                CodeLoaderSymbolsFragment expview = new CodeLoaderSymbolsFragment((Composite)folder, 0, this.context, this, co, 2, pbcu);
                this.tabman.addEntry(S.s(331), (Control)expview);
            }
            if (this.shouldDisplay(ReferencedMethodsFragment.class)) {
                this.tabman.addEntry("Referenced Methods", (Control)new ReferencedMethodsFragment((Composite)folder, 0, this.context, pbcu, this));
            }
        }
        if (this.unit instanceof IDebuggerUnit) {
            AbstractUnitFragment stkView;
            IDebuggerUnit dbg = (IDebuggerUnit)this.unit;
            IUnit parentUnit = (IUnit)dbg.getParent();
            if (parentUnit instanceof IDebuggerUnit) {
                parentUnit = (IUnit)parentUnit.getParent();
            }
            if (this.shouldDisplay(DbgLogFragment.class)) {
                DbgLogFragment logView = new DbgLogFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(448), (Control)logView);
                if (focusedControl == null) {
                    focusedControl = logView;
                }
                this.wrapCustomFragment(dbg, (Control)logView, "log");
            }
            if (this.shouldDisplay(DbgThreadsFragment.class)) {
                DbgThreadsFragment threadsView = new DbgThreadsFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(774), (Control)threadsView);
                focusedControl = threadsView;
                new AddressNavigator(this.context, threadsView.getJfaceViewer(), threadsView, parentUnit);
                this.wrapCustomFragment(dbg, (Control)threadsView, "threads");
            }
            if (this.shouldDisplay(DbgBreakpointsFragment.class)) {
                DbgBreakpointsFragment bpView = new DbgBreakpointsFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(101), (Control)bpView);
                if (focusedControl == null) {
                    focusedControl = bpView;
                }
                new AddressNavigator(this.context, bpView.getJfaceViewer(), bpView, parentUnit);
                this.wrapCustomFragment(dbg, (Control)bpView, "breakpoints");
            }
            if (this.shouldDisplay(DbgVariablesFragment.class)) {
                DbgVariablesFragment varView = new DbgVariablesFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(446), (Control)varView);
                if (focusedControl == null) {
                    focusedControl = varView;
                }
                this.wrapCustomFragment(dbg, (Control)varView, "variables");
            }
            if (this.shouldDisplay(DbgStackFragment.class)) {
                stkView = new DbgStackFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(745), (Control)stkView);
                if (focusedControl == null) {
                    focusedControl = stkView;
                }
                this.wrapCustomFragment(dbg, (Control)stkView, "stack");
            }
            if (this.shouldDisplay(DbgCodeFragment.class) && DbgCodeFragment.isValidForUnit(dbg)) {
                stkView = new DbgCodeFragment((Composite)folder, 0, this.context, dbg);
                this.tabman.addEntry(S.s(455), (Control)stkView);
                if (focusedControl == null) {
                    focusedControl = stkView;
                }
                this.wrapCustomFragment(dbg, (Control)stkView, "memoryCode");
            }
        }
        if (this.unit instanceof INativeSourceUnit && this.shouldDisplay(StaticCodeGraphFragment.class) && !(targets = (srcUnit = (INativeSourceUnit)this.unit).getDecompilationTargets()).isEmpty() && (target = targets.get(0)).getContext() != null) {
            CFG<IEStatement> cfg = target.getContext().getCfg();
            StaticCodeGraphFragment v = new StaticCodeGraphFragment((Composite)folder, 0, this.context, srcUnit, this, cfg);
            this.tabman.addEntry("IR-CFG", (Control)v);
        }
        if (focusedControl == null && this.tabman.getEntryCount() >= 1) {
            focusedControl = this.tabman.getEntryControl(0);
        }
        if (focusedControl != null) {
            this.tabman.showEntry((Control)focusedControl, true);
        }
        if (this.tabman.getEntryCount() <= 1) {
            this.tabman.getContainer().setTabHeight(0);
        }
        this.updatePartName();
    }

    private Control addUnitDocuments(CTabFolder folder) {
        AbstractUnitFragment focusedControl = null;
        ArrayList<Long> currentPresIds = new ArrayList<Long>();
        for (IUnitDocumentPresentation iUnitDocumentPresentation : this.unitFormatter.getPresentations()) {
            if (iUnitDocumentPresentation.getId() == 0L) continue;
            currentPresIds.add(iUnitDocumentPresentation.getId());
        }
        ArrayList<Long> uiPresIds = new ArrayList<Long>();
        for (Control control : this.tabman.getControls()) {
            Long presId = (Long)control.getData("presentationId");
            if (presId == null || presId == 0L) continue;
            uiPresIds.add(presId);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator iterator = uiPresIds.iterator();
        while (iterator.hasNext()) {
            long presId = (Long)iterator.next();
            if (currentPresIds.contains(presId)) continue;
            arrayList.add(presId);
        }
        for (IUnitDocumentPresentation pres : this.unitFormatter.getPresentations()) {
            AbstractUnitFragment fragment;
            long presId = pres.getId();
            if (presId != 0L && uiPresIds.contains(presId)) continue;
            String label = pres.getLabel();
            IGenericDocument doc = null;
            boolean added = false;
            if (!added && this.shouldDisplay(TextFragment.class)) {
                if (doc == null) {
                    doc = pres.getDocument();
                }
                if (doc instanceof HexDumpDocument) {
                    fragment = new BinaryDataFragment((Composite)folder, 0, this.context, this.unit, this, (HexDumpDocument)doc);
                    this.wrapDocumentFragment(fragment, pres, this.unit, "hextext");
                    this.tabman.addEntry(label, (Control)fragment);
                    if (pres.isDefaultRepresentation()) {
                        focusedControl = fragment;
                    } else {
                        fragment.setFocusPriority(0);
                    }
                    added = true;
                } else if (doc instanceof ITextDocument) {
                    fragment = new TextFragment((Composite)folder, 0, this.context, this.unit, this, (ITextDocument)doc);
                    this.wrapDocumentFragment(fragment, pres, this.unit, "text");
                    this.tabman.addEntry(label, (Control)fragment);
                    if (pres.isDefaultRepresentation()) {
                        focusedControl = fragment;
                    }
                    if (this.unit.getParent() instanceof IDecompilerUnit && this.unit instanceof IAddressableUnit) {
                        fragment.setViewNavigatorHelper(new DecompiledViewNavigator((IAddressableUnit)this.unit, this.context, this.part));
                    }
                    added = true;
                }
            }
            if (!added && this.shouldDisplay(TableFragment.class)) {
                if (doc == null) {
                    doc = pres.getDocument();
                }
                if (doc instanceof ITableDocument) {
                    fragment = new TableFragment((Composite)folder, 0, this.context, this.unit, (ITableDocument)doc, this);
                    this.wrapDocumentFragment(fragment, pres, this.unit, "table");
                    this.tabman.addEntry(label, (Control)fragment);
                    if (pres.isDefaultRepresentation()) {
                        focusedControl = fragment;
                    }
                    added = true;
                }
            }
            if (!added && this.shouldDisplay(TreeFragment.class)) {
                if (doc == null) {
                    doc = pres.getDocument();
                }
                if (doc instanceof ITreeDocument) {
                    fragment = new TreeFragment((Composite)folder, 0, this.context, this.unit, (ITreeDocument)doc, this);
                    this.wrapDocumentFragment(fragment, pres, this.unit, "tree");
                    this.tabman.addEntry(label, (Control)fragment);
                    if (pres.isDefaultRepresentation()) {
                        focusedControl = fragment;
                    }
                    added = true;
                }
            }
            if (added || doc == null) continue;
            doc.dispose();
        }
        ArrayList<Control> arrayList2 = new ArrayList<Control>();
        for (Control ctl3 : this.tabman.getControls()) {
            Long presId = (Long)ctl3.getData("presentationId");
            if (presId == null || !arrayList.contains(presId)) continue;
            arrayList2.add(ctl3);
        }
        for (Control ctl4 : arrayList2) {
            this.tabman.removeEntry(ctl4);
        }
        return focusedControl;
    }

    private void updatePartName() {
        String n0 = this.unit.getName();
        String n1 = this.tabman.getCurrentEntryName();
        String name = String.format("%s/%s", n0, n1);
        this.part.setLabel(name);
    }

    private void wrapDocumentFragment(AbstractUnitFragment<?> fragment, IUnitDocumentPresentation pres, IUnit unit, String doctype) {
        long id = pres.getId();
        String label = Strings.safe(pres.getLabel(), "noLabel");
        String sfx = id != 0L ? "" + id : label;
        RcpClientContext.wrapWidget(this.context, fragment, unit.getFormatType() + "_" + doctype + "_" + sfx);
        fragment.setData("presentationId", id);
        if (pres.isDefaultRepresentation()) {
            fragment.setDefaultFragment(true);
        }
        final IGenericDocument doc = ((IDocumentBasedFragment)((Object)fragment)).getDocument();
        fragment.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                doc.dispose();
            }
        });
    }

    private void wrapCustomFragment(IUnit unit, Control ctl, String doctype) {
        RcpClientContext.wrapWidget(this.context, ctl, unit.getFormatType() + "_" + doctype);
    }

    @Override
    public void deleteView() {
        if (this.unitListener != null) {
            this.unit.removeListener(this.unitListener);
            this.unitListener = null;
        }
        if (this.rawDoc != null) {
            this.rawDoc.dispose();
            this.rawDoc = null;
        }
        this.tabman.removeAllEntries();
        this.unit = null;
        this.fragmentList = null;
        this.fragmentBlacklist = null;
    }

    @Override
    public void setFocus() {
        this.requestFocus();
    }

    @Override
    public void onFocus() {
        if (this.isInactive()) {
            return;
        }
        this.context.getPartManager().onFocus(this.part);
        this.notifyListeners(new JebClientEvent(JC.FocusGained, this, this));
        this.tabman.setFocus();
        if (this.tabman.getCurrentEntryControl() == null) {
            this.tabman.showEntry(0, true);
        }
    }

    private boolean shouldDisplay(Class<? extends IRcpUnitFragment> fragmentClass) {
        if (this.fragmentList == null) {
            if (this.fragmentBlacklist != null) {
                return !UnitPartManager.inList(this.fragmentBlacklist, fragmentClass);
            }
            return true;
        }
        return UnitPartManager.inList(this.fragmentList, fragmentClass);
    }

    private static boolean inList(List<String> fragmentList, Class<? extends IRcpUnitFragment> targetFragmentClass) {
        if (fragmentList == null) {
            return false;
        }
        if (fragmentList.contains(targetFragmentClass.getName())) {
            return true;
        }
        for (String name : fragmentList) {
            if ("*".equalsIgnoreCase(name)) {
                return true;
            }
            try {
                Class<? extends IRcpUnitFragment> c = Class.forName(name);
                if (!c.isAssignableFrom(targetFragmentClass)) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return false;
    }

    public TabFolderView getFolder() {
        return this.tabman;
    }

    @Override
    public void setActiveFragment(IUnitFragment fragment) {
        this.setActiveFragment(fragment, true);
    }

    public void setActiveFragment(IUnitFragment fragment, boolean focus) {
        if (this.isInactive()) {
            return;
        }
        if (!(fragment instanceof IRcpUnitFragment)) {
            throw new IllegalArgumentException();
        }
        this.tabman.showEntry(((IRcpUnitFragment)fragment).getFragmentControl(), focus);
    }

    @Override
    public AbstractUnitFragment<?> getActiveFragment() {
        if (this.isInactive()) {
            return null;
        }
        Control ctl = this.tabman.getCurrentEntryControl();
        if (!(ctl instanceof AbstractUnitFragment)) {
            return null;
        }
        return (AbstractUnitFragment)ctl;
    }

    public List<AbstractUnitFragment<?>> getPreviouslyActiveFragments() {
        if (this.isInactive()) {
            return Collections.emptyList();
        }
        ArrayList r = new ArrayList();
        for (CTabItem tab : this.tabman.getPreviouslyFocusedTabs()) {
            Control ctl = tab.getControl();
            if (!(ctl instanceof AbstractUnitFragment)) continue;
            r.add((AbstractUnitFragment)ctl);
        }
        return r;
    }

    public List<IRcpUnitFragment> getFragments() {
        if (this.isInactive()) {
            return Collections.emptyList();
        }
        ArrayList<IRcpUnitFragment> r = new ArrayList<IRcpUnitFragment>();
        for (Control ctl : this.tabman.getControls()) {
            if (!(ctl instanceof AbstractUnitFragment)) continue;
            r.add((IRcpUnitFragment)ctl);
        }
        return r;
    }

    public <T extends AbstractUnitFragment<?>> T getFragmentByType(Class<T> type) {
        if (this.isInactive()) {
            return null;
        }
        for (Control ctl : this.tabman.getControls()) {
            if (!type.isInstance(ctl)) continue;
            return (T)((AbstractUnitFragment)ctl);
        }
        return null;
    }

    public AbstractUnitFragment<?> getFragmentByName(String name) {
        if (this.isInactive()) {
            return null;
        }
        for (TabFolderView.Entry e : this.tabman.getEntries()) {
            if (!(e.getControl() instanceof AbstractUnitFragment) || !Strings.equals(name, e.getName())) continue;
            return (AbstractUnitFragment)e.getControl();
        }
        return null;
    }

    public IItem getActiveItem() {
        if (this.isInactive()) {
            return null;
        }
        Control ctl = this.tabman.getCurrentEntryControl();
        if (ctl instanceof AbstractUnitFragment) {
            return ((IRcpUnitFragment)ctl).getActiveItem();
        }
        return null;
    }

    public String getActiveAddress() {
        if (this.isInactive()) {
            return null;
        }
        JebAddress address = this.getActiveAddress(AddressConversionPrecision.DEFAULT);
        return address == null ? null : address.getAddress();
    }

    public JebAddress getActiveAddress(AddressConversionPrecision precision) {
        if (this.isInactive()) {
            return null;
        }
        Control ctl = this.tabman.getCurrentEntryControl();
        if (ctl instanceof AbstractUnitFragment) {
            String activeAddress = ((IRcpUnitFragment)ctl).getActiveAddress(precision);
            if (activeAddress != null) {
                return new JebAddress(activeAddress, precision);
            }
            return new JebAddress(((IRcpUnitFragment)ctl).getActiveAddress(), AddressConversionPrecision.DEFAULT);
        }
        return null;
    }

    public Position getActivePosition() {
        if (this.isInactive()) {
            return null;
        }
        Control ctl = this.tabman.getCurrentEntryControl();
        if (ctl instanceof AbstractUnitFragment) {
            return ((IRcpUnitFragment)ctl).getActivePosition();
        }
        return null;
    }

    @Override
    public boolean setActiveAddress(String address, Object extra, boolean record) {
        if (this.isInactive()) {
            return false;
        }
        Control ctl = this.tabman.getCurrentEntryControl();
        if (ctl instanceof AbstractUnitFragment) {
            return ((IRcpUnitFragment)ctl).setActiveAddress(address, extra, record);
        }
        return false;
    }

    @Override
    public String getFragmentLabel(IUnitFragment fragment) {
        if (this.isInactive()) {
            return null;
        }
        if (!(fragment instanceof AbstractUnitFragment)) {
            throw new IllegalArgumentException("A Unit fragment was expected");
        }
        AbstractUnitFragment f = (AbstractUnitFragment)fragment;
        return this.tabman.getTab((Control)f).getText();
    }

    @Override
    public void setFragmentLabel(IUnitFragment fragment, String label) {
        if (this.isInactive()) {
            return;
        }
        if (!(fragment instanceof AbstractUnitFragment)) {
            throw new IllegalArgumentException();
        }
        AbstractUnitFragment f = (AbstractUnitFragment)fragment;
        this.tabman.getTab((Control)f).setText(label);
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (this.isInactive()) {
            return false;
        }
        if (this.delegateOperation(req, true)) {
            return true;
        }
        switch (req.getOperation()) {
            case PROPERTIES: {
                return this.unit != null;
            }
            case NAVIGATE_BACKWARD: {
                return this.context.getViewManager().getGlobalPositionHistory().hasPrevious();
            }
            case NAVIGATE_FORWARD: {
                return this.context.getViewManager().getGlobalPositionHistory().hasNext();
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (this.isInactive()) {
            return false;
        }
        if (!(req.getOperation() != Operation.REFRESH || this.unit.isProcessed() || this.unit.process() || UI.question(null, "Warning", "Processing this unit has failed. Proceed?"))) {
            return false;
        }
        if (this.delegateOperation(req, false)) {
            return true;
        }
        if (!req.proceed()) {
            return false;
        }
        switch (req.getOperation()) {
            case PROPERTIES: {
                new UnitPropertiesDialog(this.parent.getShell(), this.unit).open();
                return true;
            }
            case NAVIGATE_BACKWARD: 
            case NAVIGATE_FORWARD: {
                GlobalPosition pos;
                PartManager pman = this.context.getPartManager();
                logger.i("GlobalPositionHistory=\n%s", this.context.getViewManager().getGlobalPositionHistory());
                GlobalPosition pos0 = this.context.getViewManager().getCurrentGlobalPosition();
                GlobalPosition globalPosition = pos = req.getOperation() == Operation.NAVIGATE_BACKWARD ? this.context.getViewManager().getGlobalPositionHistory().getPrevious(pos0) : this.context.getViewManager().getGlobalPositionHistory().getNext(pos0);
                if (pos == null) {
                    return false;
                }
                IUnit unit = pos.getUnit();
                if (unit == null) {
                    return false;
                }
                IMPart targetPart = pman.getPartById(pos.getPartId(), unit);
                if (targetPart == null) {
                    if (unit.isDisposed()) {
                        return false;
                    }
                    targetPart = pman.create(unit, true).get(0);
                }
                pman.focus(targetPart);
                UnitPartManager object = pman.getUnitPartManager(targetPart);
                if (object == null) {
                    throw new JebRuntimeException(String.format("Can not restore position of %s: is it a unit part?", targetPart.toString()));
                }
                Position p = pos.getPosition();
                if (p == null) {
                    return false;
                }
                object.setActiveAddress(p.getAddress(), p.getExtra(), false);
                return true;
            }
        }
        return false;
    }

    private boolean delegateOperation(OperationRequest req, boolean verify) {
        Control ctl;
        CTabItem sel = this.tabman.getContainer().getSelection();
        if (sel != null && (ctl = sel.getControl()) instanceof IOperable) {
            if (verify) {
                return ((IOperable)ctl).verifyOperation(req);
            }
            return ((IOperable)ctl).doOperation(req);
        }
        return false;
    }

    public static MediaType getMediaTypeForUnit(IUnit unit) {
        if (!(unit instanceof IBinaryUnit)) {
            return MediaType.OCTET_STREAM;
        }
        String mimeType = ((IBinaryUnit)unit).getMimeType();
        if (mimeType == null) {
            return MediaType.OCTET_STREAM;
        }
        String[] parts = mimeType.split("/");
        if (parts.length != 2) {
            return MediaType.OCTET_STREAM;
        }
        try {
            return MediaType.create((String)parts[0], (String)parts[1]);
        }
        catch (IllegalArgumentException e) {
            return MediaType.OCTET_STREAM;
        }
    }

    public static String getIconForUnit(IUnit unit) {
        return ProjectTreeLabelProvider.getUnitIconRelativePath(unit);
    }

    public String toString() {
        return String.format("View:{%s}", this.getLabel());
    }
}

