/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.rcpclient.extensions.ContextMenuFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.PatternTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.ContentProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.LabelProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.TreeUtil;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePatternMatcher;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class InteractiveTreeViewer
implements IOperable,
IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(InteractiveTreeViewer.class);
    private static final int columnMaxWidth = 250;
    private ITreeDocument idoc;
    private IEventListener idocListener;
    private PatternTreeView pt;
    private FilteredTreeViewer viewer;
    private IStyleProvider styleAdapter;

    public InteractiveTreeViewer(Composite parent, int style, ITreeDocument idoc, IPropertyManager propertyManager) {
        final Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.idoc = idoc;
        List<String> columnLabels = idoc.getColumnLabels();
        if (columnLabels == null) {
            columnLabels = new ArrayList<String>();
        }
        String[] columnNames = columnLabels.toArray(new String[columnLabels.size()]);
        LabelProvider labelProvider = new LabelProvider(this);
        SimplePatternMatcher patternMatcher = new SimplePatternMatcher(labelProvider);
        boolean expandAfterFilter = propertyManager.getBoolean(".ui.ExpandTreeNodesOnFiltering");
        this.pt = new PatternTreeView(container, 65664, columnNames, null, patternMatcher, expandAfterFilter);
        this.viewer = this.pt.getTreeViewer();
        ContextMenuFilter.addContextMenu(this.viewer.getViewer(), this.pt.getFilterText(), labelProvider, columnNames, null, this);
        this.pt.getTree().setHeaderVisible(true);
        this.pt.getTree().setLinesVisible(true);
        if ((style & 0x10000000) != 0) {
            throw new RuntimeException("Unsupported");
        }
        this.viewer.setContentProvider(new ContentProvider());
        ((TreeViewer)this.viewer.getViewer()).setUseHashlookup(true);
        this.viewer.setLabelProvider(labelProvider);
        this.idocListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                UIExecutor.async((Widget)container, new UIRunnable(){

                    @Override
                    public void runi() {
                        InteractiveTreeViewer.this.viewer.refresh();
                    }
                });
            }
        };
        idoc.addListener(this.idocListener);
    }

    public void initialize() {
        this.viewer.setInput(this.idoc);
        int level = this.idoc.getInitialExpansionLevel();
        if (level < 0) {
            this.viewer.expandAll();
        } else if (level > 0) {
            this.viewer.expandToLevel(level);
        }
        for (TreeColumn tc : this.pt.getTree().getColumns()) {
            tc.setMoveable(true);
            tc.pack();
        }
        for (TreeColumn tc : this.pt.getTree().getColumns()) {
            if (tc.getWidth() <= 250) continue;
            tc.setWidth(250);
        }
    }

    public void dispose() {
        this.idoc.removeListener(this.idocListener);
    }

    public void setStyleAdapter(IStyleProvider styleAdapter) {
        this.styleAdapter = styleAdapter;
    }

    public IStyleProvider getStyleAdapter() {
        return this.styleAdapter;
    }

    public FilteredTreeViewer getFilteredTreeViewer() {
        return this.viewer;
    }

    public TreeViewer getViewer() {
        return (TreeViewer)this.viewer.getViewer();
    }

    public Tree getTreeWidget() {
        return this.pt.getTree();
    }

    public ITreeDocument getInfiniDocument() {
        return this.idoc;
    }

    public INode getSelectedNode() {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        if (selection == null) {
            return null;
        }
        Object elt = selection.getFirstElement();
        if (!(elt instanceof INode)) {
            return null;
        }
        return (INode)elt;
    }

    public boolean setPosition(INodeCoordinates coord, boolean record) {
        List<Integer> seq = coord.getPath();
        if (seq == null || seq.isEmpty()) {
            return false;
        }
        List<? extends INode> list = this.idoc.getRoots();
        INode node = null;
        for (int i : seq) {
            if (list == null) {
                node = null;
                break;
            }
            this.viewer.expandToLevel(node, 1);
            if (i < 0 || i >= list.size()) {
                return false;
            }
            node = list.get(i);
            list = node.getChildren();
        }
        this.viewer.setSelection(new StructuredSelection(node), true);
        return true;
    }

    public NodeCoordinates getPosition() {
        INode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        ArrayList<Integer> seq = new ArrayList<Integer>();
        TreeItem item = this.pt.getTree().getSelection()[0];
        while (item != null) {
            int i;
            TreeItem parentItem = item.getParentItem();
            TreeItem[] items = null;
            items = parentItem == null ? this.pt.getTree().getItems() : parentItem.getItems();
            for (i = 0; i < items.length && items[i] != item; ++i) {
            }
            if (i >= items.length) {
                return null;
            }
            seq.add(0, i);
            item = parentItem;
        }
        return new NodeCoordinates(seq);
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        menuMgr.add(new OperationCopy(this));
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case COPY: {
                return this.getSelectedNode() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                this.pt.setFilterVisibility(true, true);
                return true;
            }
            case COPY: {
                INode node = this.getSelectedNode();
                if (node == null) {
                    return false;
                }
                String s = Strings.safe(node.getLabel()).replace("\\", "\\\\").replace("|", "\\|");
                StringBuilder sb = new StringBuilder(s);
                String[] additionalLabels = node.getAdditionalLabels();
                if (additionalLabels != null) {
                    for (String additionalLabel : additionalLabels) {
                        sb.append('|');
                        sb.append(Strings.safe(additionalLabel).replace("\\", "\\\\").replace("|", "\\|"));
                    }
                }
                UIUtil.copyTextToClipboard(sb.toString());
                return true;
            }
        }
        return false;
    }

    public String exportToString() {
        return TreeUtil.buildXml(this.getTreeWidget(), 2);
    }
}

