/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;

class ContentProvider
implements IFilteredTreeContentProvider {
    private static final ILogger logger = GlobalLog.getLogger(ContentProvider.class);
    ITreeDocument input;

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = (ITreeDocument)newInput;
    }

    @Override
    public Object[] getChildren(Object e) {
        if (e instanceof ITreeDocument) {
            logger.i("getChildren() of root", new Object[0]);
            return ((ITreeDocument)e).getRoots().toArray();
        }
        if (e instanceof INode) {
            List<? extends INode> l = ((INode)e).getChildren();
            logger.i("getChildren(%s)", ((INode)e).getLabel());
            if (l != null) {
                return l.toArray();
            }
        }
        return new Object[0];
    }

    @Override
    public Object[] getElements(Object e) {
        return this.getChildren(e);
    }

    @Override
    public Object getParent(Object e) {
        return null;
    }

    @Override
    public boolean hasChildren(Object e) {
        return this.getChildren(e).length > 0;
    }

    @Override
    public Object[] getRowElements(Object row) {
        if (row instanceof INode) {
            INode n = (INode)row;
            String[] additionalLabels = n.getAdditionalLabels();
            int rowSize = 1 + (additionalLabels == null ? 0 : additionalLabels.length);
            Object[] rowElements = new Object[rowSize];
            rowElements[0] = Strings.replaceNewLines(n.getLabel(), " / ");
            if (additionalLabels != null) {
                for (int i = 0; i < additionalLabels.length; ++i) {
                    rowElements[i + 1] = Strings.replaceNewLines(additionalLabels[i], " / ");
                }
            }
            return rowElements;
        }
        return null;
    }
}

