/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.render.IDexDisassemblyDocument;
import com.pnfsoftware.jeb.core.units.code.asm.render.INativeDisassemblyDocument;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.UnwrappedBufferPoint;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentManager {
    private final ITextDocument doc;
    private ITextDocumentPart docPart;
    private boolean displayEolAtEod;
    public static final int defaultCharactersWrap = 80;
    private int hintMaxCharsPerLine = -1;
    private int maxDeltaForWSP = 10;
    private String wrapIndentString = "        ";
    private List<int[]> wrappedData = new ArrayList<int[]>();
    private Map<Integer, List<Integer>> wrapIndexes = new HashMap<Integer, List<Integer>>();
    private String docText;
    private List<RenderedItem> renderedItems = new ArrayList<RenderedItem>();

    public DocumentManager(ITextDocument doc) {
        this(doc, false);
    }

    public DocumentManager(ITextDocument doc, boolean displayEolAtEod) {
        this.doc = doc;
        this.displayEolAtEod = displayEolAtEod;
    }

    public void setCharactersWrap(int charactersWrap) {
        if (charactersWrap == 0) {
            charactersWrap = 80;
        }
        this.hintMaxCharsPerLine = charactersWrap;
    }

    public int getCharactersWrap() {
        return this.hintMaxCharsPerLine;
    }

    public ITextDocumentPart getCurrentPart() {
        return this.docPart;
    }

    public void setCurrentPart(ITextDocumentPart docPart) {
        this.docPart = docPart;
        this.docText = this.buildTextInternal();
    }

    public String getText() {
        return this.docText;
    }

    public ITextDocument getDocument() {
        return this.doc;
    }

    public boolean isSingleAnchorDocument() {
        return this.doc.getAnchorCount() == 1L;
    }

    public long getAnchorRange() {
        return this.doc.getAnchorCount();
    }

    public long getAnchorFirst() {
        return this.doc.getFirstAnchor();
    }

    public long getAnchorEnd() {
        return this.doc.getFirstAnchor() + this.doc.getAnchorCount();
    }

    public ITextDocumentPart getPart(long anchorId, int linesAfter) {
        try {
            ITextDocumentPart newDocPart = this.doc.getDocumentPart(anchorId, linesAfter);
            return newDocPart;
        }
        catch (RuntimeException e) {
            throw new JebRuntimeException(Strings.f("Rendering Exception on part at %d,%d for %s", anchorId, linesAfter, this.getDocumentName()), e);
        }
    }

    public ITextDocumentPart getPart(long anchorId, int linesAfter, int linesBefore) {
        try {
            ITextDocumentPart newDocPart = this.doc.getDocumentPart(anchorId, linesAfter, linesBefore);
            return newDocPart;
        }
        catch (RuntimeException e) {
            throw new JebRuntimeException(Strings.f("Rendering Exception on part at %d,%d,%d for %s", anchorId, linesAfter, linesBefore, this.getDocumentName()), e);
        }
    }

    private String getDocumentName() {
        if (this.doc instanceof INativeDisassemblyDocument) {
            INativeCodeUnit<?> unit = ((INativeDisassemblyDocument)this.doc).getUnit();
            return unit.getName() + "[" + unit.getParent().getName() + "]";
        }
        if (this.doc instanceof IDexDisassemblyDocument) {
            IDexUnit unit = ((IDexDisassemblyDocument)this.doc).getUnit();
            return unit.getName() + "[" + unit.getParent().getName() + "]";
        }
        return this.doc.toString() + "[count=" + this.doc.getAnchorCount() + "]";
    }

    public IAnchor getAnchorById(long anchorId) {
        if (this.getCurrentPart() == null) {
            return null;
        }
        return TextPartUtil.getAnchorById(this.getCurrentPart(), anchorId);
    }

    public int unwrapLine(int wrappedLineIndex) {
        if (wrappedLineIndex < 0 || wrappedLineIndex >= this.wrappedData.size()) {
            return -1;
        }
        return this.wrappedData.get(wrappedLineIndex)[0];
    }

    public UnwrappedBufferPoint unwrap(BufferPoint p) {
        int columnOffset;
        boolean eol;
        int wrappedLineIndex = p.lineIndex;
        if (wrappedLineIndex < 0 || wrappedLineIndex >= this.wrappedData.size()) {
            return null;
        }
        int[] data = this.wrappedData.get(wrappedLineIndex);
        int lineIndex = data[0];
        int wrappedColumnOffset = p.columnOffset;
        boolean bl = eol = wrappedColumnOffset == data[2];
        if (data[1] == 0) {
            columnOffset = wrappedColumnOffset;
        } else {
            int currentWrapIndentSize = data[3];
            columnOffset = data[1] + Math.max(currentWrapIndentSize, wrappedColumnOffset) - currentWrapIndentSize;
        }
        return new UnwrappedBufferPoint(columnOffset, lineIndex, eol);
    }

    public int wrapLine(int lineIndex) {
        BufferPoint p = this.wrap(new UnwrappedBufferPoint(0, lineIndex, false));
        if (p == null) {
            return -1;
        }
        return p.lineIndex;
    }

    public BufferPoint wrap(UnwrappedBufferPoint p) {
        int lineIndex = p.lineIndex;
        int columnOffset = p.columnOffset;
        boolean eol = p.eol;
        List<Integer> indexes = this.wrapIndexes.get(p.lineIndex);
        if (indexes == null || indexes.isEmpty()) {
            return null;
        }
        int i = indexes.get(0);
        int[] data = this.wrappedData.get(i);
        if (this.isEmptyLine(indexes) || indexes.size() == 1 || columnOffset < data[2] || eol && columnOffset == data[2]) {
            return new BufferPoint(columnOffset, i);
        }
        for (int j = 1; j < indexes.size() && (data = this.wrappedData.get(i = indexes.get(j).intValue()))[0] == lineIndex; ++j) {
            if (columnOffset < data[1] || columnOffset >= data[2] && (!eol || columnOffset != data[2])) continue;
            return new BufferPoint(columnOffset - data[1] + data[3], i);
        }
        return null;
    }

    private boolean isEmptyLine(List<Integer> indexes) {
        int i = indexes.get(0);
        int[] data = this.wrappedData.get(i);
        return indexes.size() == 1 && data.length == 3;
    }

    List<RenderedItem> getRenderedItems() {
        return this.renderedItems;
    }

    public int getLineCount() {
        return this.docPart.getLines().size();
    }

    public int getWrappedLineCount() {
        return this.wrappedData.size();
    }

    private String buildTextInternal() {
        this.wrappedData.clear();
        this.renderedItems.clear();
        this.wrapIndexes.clear();
        boolean appendTrailingEol = false;
        if (this.displayEolAtEod) {
            IAnchor lastAnchor = this.docPart.getAnchors().get(this.docPart.getAnchors().size() - 1);
            appendTrailingEol = lastAnchor.getIdentifier() >= this.getAnchorEnd() - 1L;
        }
        return this.buildText(this.docPart.getLines(), appendTrailingEol);
    }

    public String buildText(List<? extends ILine> lines) {
        return this.buildText(lines, true);
    }

    /*
     * Could not resolve type clashes
     */
    private String buildText(List<? extends ILine> lines, boolean appendTrailingEol) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < lines.size(); ++index) {
            ILine line = lines.get(index);
            CharSequence text = line.getText();
            String currentWrapIndentString = this.wrapIndentString;
            int currentWrapIndentSize = -1;
            if (text.length() == 0) {
                this.addIndex(index, this.wrappedData.size());
                this.wrappedData.add(new int[]{index, 0, 0});
            } else {
                int pos = 0;
                while (pos < text.length()) {
                    int wspPos;
                    int pos2 = this.hintMaxCharsPerLine > 0 ? pos + this.hintMaxCharsPerLine : text.length();
                    if (pos2 < text.length() && (wspPos = this.findWhiteSpace(text, pos2)) >= 0 && wspPos - pos2 <= this.maxDeltaForWSP) {
                        pos2 = wspPos;
                    }
                    if (pos2 >= text.length()) {
                        pos2 = text.length();
                    } else {
                        int itemThreshold = -1;
                        int nextItemThreshold = -1;
                        List<? extends ITextItem> items = line.getItems();
                        for (int i = 0; i < items.size(); ++i) {
                            ITextItem item = items.get(i);
                            if (pos2 >= item.getOffset() && pos2 < item.getOffset() + item.getLength()) {
                                itemThreshold = item.getOffset() + item.getLength();
                                pos2 = this.findWhiteSpace(text, itemThreshold, nextItemThreshold = i + 1 < items.size() ? items.get(i + 1).getOffset() : -1);
                                if (pos2 >= 0) break;
                                pos2 = itemThreshold;
                                break;
                            }
                            if (pos2 < item.getOffset()) break;
                        }
                    }
                    if (pos > 0) {
                        if (currentWrapIndentSize < 0) {
                            currentWrapIndentString = this.extractEmptyPrefix(text) + this.wrapIndentString;
                            currentWrapIndentSize = currentWrapIndentString.length();
                        }
                        sb.append('\n');
                        sb.append(currentWrapIndentString);
                    }
                    for (ITextItem item : line.getItems()) {
                        if (item.getOffset() < pos) continue;
                        if (item.getOffset() >= pos2) break;
                        int renderedItemOffset = sb.length() + (item.getOffset() - pos);
                        this.renderedItems.add(new RenderedItem(item, renderedItemOffset));
                    }
                    sb.append(text.subSequence(pos, pos2));
                    this.addIndex(index, this.wrappedData.size());
                    this.wrappedData.add(new int[]{index, pos, pos2, currentWrapIndentSize});
                    pos = pos2;
                }
            }
            if (index + 1 >= lines.size() && !appendTrailingEol) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private void addIndex(int key, int index) {
        List<Integer> indexes = this.wrapIndexes.get(key);
        if (indexes == null) {
            indexes = new ArrayList<Integer>();
            this.wrapIndexes.put(key, indexes);
        }
        indexes.add(index);
    }

    private int findWhiteSpace(CharSequence text, int pos) {
        return this.findWhiteSpace(text, pos, -1);
    }

    private int findWhiteSpace(CharSequence text, int pos, int end) {
        if (end < 0 || end > text.length()) {
            end = text.length();
        }
        while (pos < end) {
            char c = text.charAt(pos);
            if (c == ' ' || c == '\t') {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private CharSequence extractEmptyPrefix(CharSequence text) {
        char c;
        int pos;
        for (pos = 0; pos < text.length() && ((c = text.charAt(pos)) == ' ' || c == '\t'); ++pos) {
        }
        return text.subSequence(0, pos);
    }

    static class RenderedItem {
        public ITextItem item;
        public int offset;

        public RenderedItem(ITextItem item, int offset) {
            this.item = item;
            this.offset = offset;
        }
    }
}

