/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.exceptions.UnitLockedException;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeActionUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class ActionDefineDataHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionDefineDataHandler.class);

    public ActionDefineDataHandler() {
        super("defineData", "Create Simple Data", 68);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true);
    }

    @Override
    public void execute() {
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        long a = this.getActiveMemoryAddress(this.part, pbcu);
        INativeType primType = null;
        boolean typeSet = false;
        INativeType type = pbcu.getDataTypeAt(a);
        while (!typeSet && primType != (type = NativeActionUtil.rotateType(pbcu.getTypeManager(), type))) {
            if (primType == null) {
                primType = type;
            }
            try {
                typeSet = pbcu.setDataTypeAt(a, type);
            }
            catch (UnitLockedException e) {
                throw e;
            }
            catch (Exception e) {
                logger.catching(e);
            }
        }
        if (!typeSet) {
            logger.error("Failed to define data at address %Xh", a);
        }
        this.postExecute();
    }
}

