/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredTreeView
extends AbstractFilteredView<Tree> {
    public FilteredTreeView(Composite parent, int style, String[] columnNames) {
        this(parent, style, columnNames, null);
    }

    public FilteredTreeView(Composite parent, int style, String[] columnNames, int[] columnWidths) {
        super(parent, style, columnNames, columnWidths, false);
    }

    public Tree getTree() {
        return (Tree)this.getElement();
    }

    @Override
    protected Tree buildElement(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, true));
        return tree;
    }

    @Override
    protected void buildColumn(Tree parent, String name, int initialWidth) {
        TreeColumn col = new TreeColumn(parent, 16384);
        col.setText(name);
        col.setResizable(true);
        if (initialWidth > 0) {
            col.setWidth(initialWidth);
        }
    }

    @Override
    public int getSelectionIndex() {
        if (((Tree)this.getElement()).getSelectionCount() == 0) {
            return -1;
        }
        AtomicInteger counter = new AtomicInteger(0);
        boolean found = this.getIndexOfItem(((Tree)this.getElement()).getItems(), ((Tree)this.getElement()).getSelection()[0], counter);
        if (found) {
            return counter.get();
        }
        return -1;
    }

    private boolean getIndexOfItem(TreeItem[] fullTree, TreeItem toFind, AtomicInteger currentIndex) {
        for (TreeItem item : fullTree) {
            if (FilteredTreeView.isBlankItem(item)) continue;
            if (item.equals(toFind)) {
                return true;
            }
            currentIndex.incrementAndGet();
            boolean found = this.getIndexOfItem(item.getItems(), toFind, currentIndex);
            if (!found) continue;
            return found;
        }
        return false;
    }

    @Override
    public void setSelection(int index) {
    }

    @Override
    public int getItemCount() {
        return this.getItemCount(((Tree)this.getElement()).getItems());
    }

    private int getItemCount(TreeItem[] items) {
        int childrenCount = 0;
        if (items == null || items.length == 0) {
            return childrenCount;
        }
        for (TreeItem item : items) {
            if (FilteredTreeView.isBlankItem(item)) continue;
            childrenCount += 1 + this.getItemCount(item.getItems());
        }
        return childrenCount;
    }

    private static boolean isBlankItem(TreeItem item) {
        return (item.getItems() == null || item.getItems().length == 0) && item.getData() == null && item.getText().isEmpty();
    }
}

