/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.app.model;

import com.pnfsoftware.jeb.rcpclient.extensions.app.App;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Dock;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Folder;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Part;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IAppService;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMDock;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMElement;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMFolder;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.util.PartUtil;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AppService
implements IAppService {
    private static final ILogger logger = GlobalLog.getLogger(AppService.class);
    private static final boolean is_linux = OSType.determine().isLinux();
    App app;
    private Control lastGoodFocusControl;

    public AppService(App app) {
        if (app == null) {
            throw new NullPointerException();
        }
        this.app = app;
    }

    @Override
    public <T extends IMElement> List<T> findElements(IMElement root, String id, Class<T> type, Collection<String> tags, int flags) {
        if (id != null) {
            throw new RuntimeException("Not supported yet");
        }
        if (tags != null && !tags.isEmpty()) {
            throw new RuntimeException("Not supported yet");
        }
        ArrayList out = new ArrayList();
        if (root == null) {
            for (Shell s : this.app.getDisplay().getShells()) {
                for (Control c : s.getChildren()) {
                    if (!(c instanceof Dock)) continue;
                    this.findElementsRecurse((Dock)c, id, type, tags, flags, out);
                }
            }
        } else {
            this.findElementsRecurse(root, id, type, tags, flags, out);
        }
        return out;
    }

    public <T extends IMElement> void findElementsRecurse(IMElement elt, String id, Class<T> type, Collection<String> tags, int flags, List<T> out) {
        boolean include = true;
        if (type != null && !type.isAssignableFrom(elt.getClass())) {
            include = false;
        }
        if (include) {
            out.add(elt);
        }
        for (IMElement iMElement : elt.getChildrenElements()) {
            this.findElementsRecurse(iMElement, id, type, tags, flags, out);
        }
    }

    @Override
    public IMDock createDock() {
        return this.app.getDock().createAdditionalDock();
    }

    @Override
    public IMDock createDock(boolean onTop, Rectangle initialBounds) {
        Dock dock2 = this.app.getDock().createAdditionalDock(onTop, 16, initialBounds);
        return dock2;
    }

    @Override
    public IMPart createPart(IMFolder folder, IMPartManager partManager) {
        if (folder == null) {
            folder = this.app.getDock().getFolders().get(0);
        }
        IMPart part = folder.addPart();
        if (partManager != null) {
            part.setManager(partManager);
        }
        return part;
    }

    @Override
    public void activate(IMPart part) {
        this.activate(part, false);
    }

    @Override
    public void activate(IMPart part, boolean focus) {
        if (focus) {
            this.focusPart(part);
        } else {
            this.showPart(part);
        }
    }

    @Override
    public void hidePart(IMPart part) {
        Folder folder = (Folder)part.getParentElement();
        folder.hidePart((Part)part);
    }

    @Override
    public void unhidePart(IMPart part) {
        Folder folder = (Folder)part.getParentElement();
        folder.unhidePart((Part)part);
    }

    @Override
    public void clearPart(IMPart part) {
        Folder folder = (Folder)part.getParentElement();
        folder.clearPart((Part)part);
    }

    public void showPart(IMPart part) {
        Folder folder = (Folder)part.getParentElement();
        folder.showPart((Part)part);
    }

    public void focusPart(IMPart part) {
        Folder folder = (Folder)part.getParentElement();
        folder.focusPart((Part)part);
    }

    @Override
    public boolean isPartVisible(IMPart part) {
        return !((Part)part).isHidden();
    }

    @Override
    public IMPart getActivePart() {
        Control ctl = this.app.getDisplay().getFocusControl();
        if (ctl == null) {
            if (is_linux && this.lastGoodFocusControl != null && !this.lastGoodFocusControl.isDisposed()) {
                ctl = this.lastGoodFocusControl;
            }
            if (ctl == null) {
                return null;
            }
        }
        this.lastGoodFocusControl = ctl;
        return PartUtil.getPart(ctl);
    }

    @Override
    public Collection<IMPart> getParts() {
        ArrayList<IMPart> r = new ArrayList<IMPart>();
        for (Dock dock : Dock.findDocks(this.app.getDisplay())) {
            for (Folder folder : dock.getFolders()) {
                for (Part part : folder.getParts()) {
                    r.add(part);
                }
            }
        }
        return r;
    }
}

