/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.IGraphicalTaskExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProxyConfigDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(ProxyConfigDialog.class);
    NetProxyInfo proxyinfo;
    NetProxyInfo proxyinfo2;
    IGraphicalTaskExecutor executor;
    Combo widgetType;
    Text widgetHostname;
    Text widgetPort;
    Text widgetUsername;
    Text widgetPassword;
    Text widgetWhitelist;

    public ProxyConfigDialog(Shell parent, NetProxyInfo proxyinfo, IGraphicalTaskExecutor executor) {
        super(parent, S.s(668), true, true);
        this.proxyinfo = proxyinfo;
        this.executor = executor;
    }

    @Override
    public NetProxyInfo open() {
        super.open();
        return this.proxyinfo2;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        Group grpSettings = UIUtil.createGroupGrid(parent, "Settings", 2, 2);
        UIUtil.createLabel((Composite)grpSettings, S.s(672));
        this.widgetType = new Combo((Composite)grpSettings, 12);
        GridData layoutData = UIUtil.createGridDataFillHorizontally();
        layoutData.widthHint = UIUtil.determineTextWidth((Control)this.widgetType, 40);
        this.widgetType.setLayoutData((Object)layoutData);
        for (String proxyType : NetProxyInfo.getProxyTypesWithDescriptions()) {
            this.widgetType.add(proxyType);
        }
        this.widgetType.select(0);
        this.widgetType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyConfigDialog.this.onProxyTypeChange();
            }
        });
        UIUtil.createLabel((Composite)grpSettings, S.s(670));
        this.widgetHostname = new Text((Composite)grpSettings, 2052);
        this.widgetHostname.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        UIUtil.createLabel((Composite)grpSettings, S.s(671));
        this.widgetPort = new Text((Composite)grpSettings, 2052);
        this.widgetPort.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Group grpAuth = UIUtil.createGroupGrid(parent, "Authentication (optional)", 2, 2);
        UIUtil.createLabel((Composite)grpAuth, S.s(811));
        this.widgetUsername = new Text((Composite)grpAuth, 2052);
        this.widgetUsername.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        UIUtil.createLabel((Composite)grpAuth, S.s(631));
        this.widgetPassword = new Text((Composite)grpAuth, 2052);
        this.widgetPassword.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Group grpWhitelist = UIUtil.createGroupGrid(parent, "Whitelist (always direct connect to those hosts)", 2, 1);
        grpWhitelist.setToolTipText("Comma-separated list of IPs or domains for which direction connection attempts will be made");
        this.widgetWhitelist = UIUtil.createTextboxInGrid((Composite)grpWhitelist, 2050, 50, 3, true, true);
        if (this.proxyinfo != null) {
            int index = this.proxyinfo.getTypeIndex();
            if (index >= 0) {
                this.widgetType.select(index);
            }
            this.widgetHostname.setText(Strings.safe(this.proxyinfo.getRecordedHostname()));
            this.widgetPort.setText(Integer.toString(this.proxyinfo.getRecordedPort()));
            this.widgetUsername.setText(Strings.safe(this.proxyinfo.getRecordedUser()));
            this.widgetPassword.setText(Strings.safe(this.proxyinfo.getRecordedPassword()));
            this.widgetWhitelist.setText(Strings.safe(this.proxyinfo.getRecordedWhitelist()));
        }
        this.onProxyTypeChange();
        this.createButtons(parent, 0, Arrays.asList(new JebDialog.Btn(32, S.s(605)), new JebDialog.Btn(256, S.s(105)), new JebDialog.Btn(-1879048192, "Connection Test...")), 32);
    }

    private void onProxyTypeChange() {
        boolean enabled = this.widgetType.getSelectionIndex() > 0;
        this.widgetHostname.setEnabled(enabled);
        this.widgetPort.setEnabled(enabled);
        this.widgetUsername.setEnabled(enabled);
        this.widgetPassword.setEnabled(enabled);
        this.widgetWhitelist.setEnabled(enabled);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            NetProxyInfo i = this.generateProxyInfoObject();
            if (i == null) {
                UI.error("Invalid proxy information");
                return;
            }
            this.proxyinfo2 = i;
            super.onConfirm();
        } else if (buttonId == -1879048192) {
            NetProxyInfo i = this.generateProxyInfoObject();
            if (i == null) {
                UI.error("Invalid proxy information");
                return;
            }
            if (this.verify(i)) {
                UI.info("Connection test succeeded");
            } else {
                UI.warn("Connection test failed!");
            }
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private NetProxyInfo generateProxyInfoObject() {
        int index = this.widgetType.getSelectionIndex();
        if (index < 0 || index >= NetProxyInfo.getProxyTypes().size()) {
            UI.error("Illegal proxy type");
            return null;
        }
        String typestr = NetProxyInfo.getProxyTypes().get(index);
        String hostname = this.widgetHostname.getText();
        if (Strings.isBlank(hostname) && index != 0) {
            UI.error("Illegal hostname");
            return null;
        }
        int port = Conversion.stringToInt(this.widgetPort.getText());
        if ((port <= 0 || port >= 65535) && index != 0) {
            UI.error("Illegal port number");
            return null;
        }
        String username = this.widgetUsername.getText();
        String password = this.widgetPassword.getText();
        String whitelist = this.widgetWhitelist.getText();
        return new NetProxyInfo(typestr, hostname, port, username, password, whitelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(NetProxyInfo newProxyinfo) {
        final AtomicBoolean r = new AtomicBoolean();
        NetProxyInfo previousProxyinfo = Net.getGlobalProxyInformation();
        try {
            Net.setGlobalProxyInformation(newProxyinfo);
            final Net net = new Net();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        net.queryBinary("https://www.pnfsoftware.com/ping");
                        r.set(true);
                    }
                    catch (IOException e1) {
                        logger.catching(e1);
                        UI.error("The connectivity test failed:\n\n" + e1);
                    }
                }
            };
            if (this.executor == null) {
                logger.info("Verifying connectivity, please wait...", new Object[0]);
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)task);
            } else {
                this.executor.executeTaskWithPopupDelay(500, "Verifying connectivity...", false, task);
            }
        }
        finally {
            Net.setGlobalProxyInformation(previousProxyinfo);
        }
        return r.get();
    }
}

