/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.LogDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Document;

public class DecompilerListener {
    private static final ILogger logger = GlobalLog.getLogger(DecompilerListener.class);
    private static Map<IDecompilerUnit, DecompilerListener> map = new IdentityHashMap<IDecompilerUnit, DecompilerListener>();
    private int clientCount;
    private IDecompilerUnit decomp;
    private RcpClientContext context;
    private IEventListener listener;
    private LogDocument eventLog;
    private Map<ISourceUnit, Integer> resetMap = new IdentityHashMap<ISourceUnit, Integer>();

    public static synchronized DecompilerListener listenTo(IDecompilerUnit decomp, RcpClientContext context) {
        DecompilerListener listener = map.get(decomp);
        if (listener == null) {
            listener = new DecompilerListener(decomp, context);
            map.put(decomp, listener);
        }
        ++listener.clientCount;
        return listener;
    }

    public static synchronized boolean stopListening(IDecompilerUnit decomp) {
        DecompilerListener listener = map.get(decomp);
        if (listener == null) {
            return false;
        }
        --listener.clientCount;
        if (listener.clientCount <= 0) {
            listener.close();
            map.remove(decomp);
        }
        return true;
    }

    public static synchronized DecompilerListener get(IDecompilerUnit decomp) {
        return map.get(decomp);
    }

    public static synchronized List<DecompilerListener> getAll() {
        return new ArrayList<DecompilerListener>(map.values());
    }

    private DecompilerListener(IDecompilerUnit decomp, RcpClientContext context) {
        this.decomp = decomp;
        this.context = context;
        this.eventLog = new LogDocument(0x100000);
        this.listener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                DecompilerListener.this.onDebugEvent(e);
            }
        };
        decomp.addListener(this.listener);
    }

    public IDecompilerUnit getDecompiler() {
        return this.decomp;
    }

    public RcpClientContext getContext() {
        return this.context;
    }

    public Document getLog() {
        return this.eventLog;
    }

    private void close() {
        if (this.listener != null) {
            this.decomp.removeListener(this.listener);
        }
        this.pullResetUnits();
    }

    private void onDebugEvent(final IEvent e) {
        if (e.getSource() != this.decomp) {
            return;
        }
        UIExecutor.async(UI.getDisplay(), new UIRunnable(){

            @Override
            public void runi() {
                DecompilerListener.this.processEvent(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(IEvent e) {
        ISourceUnit srcUnit;
        String addition = String.format("%s", e.getType());
        if (e.getData() != null) {
            addition = addition + String.format(" / %s", e.getData());
        }
        addition = addition + "\n";
        this.eventLog.append(addition);
        if (e.getType() == J.DecompClientNotification) {
            ClientNotification n = (ClientNotification)e.getData();
            String message = n.getMessage();
            int level = RcpClientContext.clientNotificationLevelToLoggerLevel(n.getLevel());
            UI.log(level, null, "Decompiler Notification", message);
        } else if (e.getType() == J.DecompSrcUnitResetEvent && (srcUnit = (ISourceUnit)e.getData()) != null) {
            logger.i("The following source unit was reset: %s", srcUnit);
            Map<ISourceUnit, Integer> map = this.resetMap;
            synchronized (map) {
                this.resetMap.put(srcUnit, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ISourceUnit> pullResetUnits() {
        Map<ISourceUnit, Integer> map = this.resetMap;
        synchronized (map) {
            ArrayList<ISourceUnit> r = new ArrayList<ISourceUnit>(this.resetMap.keySet());
            this.resetMap.clear();
            return r;
        }
    }
}

