/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.parser.PdfComment;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;

public class PdfHeaderParser {
    private static final ILogger logger = GlobalLog.getLogger(PdfHeaderParser.class);
    private static final byte[] PDF_HEADER = "%PDF-1".getBytes();
    private IInput input;

    public PdfHeaderParser(IInput input) {
        this.input = input;
    }

    public boolean isPdf() {
        if (this.input == null) {
            return false;
        }
        try {
            byte[] data = IO.readInputStream((InputStream)this.input.getStream());
            for (int cursor = 0; cursor < data.length; ++cursor) {
                if (PdfSpecialCharacters.isSeparator(data[cursor]) || !PdfSpecialCharacters.isComment(data[cursor])) continue;
                if (this.isPdfHeader(data, cursor)) {
                    return true;
                }
                cursor = PdfComment.skipCommentsIfSome(data, cursor - 1);
            }
        }
        catch (IOException e) {
            logger.catching((Throwable)e);
        }
        return false;
    }

    private boolean isPdfHeader(byte[] data, int cursor) {
        if (cursor + 5 >= data.length) {
            return false;
        }
        return data[cursor + 1] == PDF_HEADER[1] && data[cursor + 2] == PDF_HEADER[2] && data[cursor + 3] == PDF_HEADER[3] && data[cursor + 4] == PDF_HEADER[4] && data[cursor + 5] == PDF_HEADER[5];
    }
}

