/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.LibraUnit;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LibraIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(LibraIdentifier.class);
    public static final String TYPE = "libravm";
    public static final Version VERSION = Version.create((int)0, (int)1);

    public LibraIdentifier() {
        super(TYPE, 0.0);
    }

    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Libra contract parser", "Parser for Libra VM binary modules and scripts (1.0) ", "PNF Software", VERSION);
    }

    public boolean canIdentify(IInput input, IUnitCreator parent) {
        if (!LibraIdentifier.checkBytes((IInput)input, (int)0, (int[])new int[]{76, 73, 66, 82, 65, 86, 77, 10})) {
            return false;
        }
        ByteBuffer hdr = input.getHeader();
        if (hdr.limit() < 10) {
            return false;
        }
        hdr.order(ByteOrder.LITTLE_ENDIAN);
        byte verMaj = hdr.get(8);
        byte verMin = hdr.get(9);
        if (verMaj != 1 || verMin != 0) {
            logger.warn("Unsupported Libra module version: %d.%d", new Object[]{(int)verMaj, (int)verMin});
            return false;
        }
        return true;
    }

    public IUnit prepare(String name, IInput input, IUnitProcessor unitProcessor, IUnitCreator parent) {
        LibraUnit unit = new LibraUnit(name, input, unitProcessor, parent, this.pdm);
        return unit;
    }
}

