/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.Libra;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.AbstractNativeDecompilerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilationTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.EMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptFilterCanDiscard;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardTypeManager;

public class LibraDecompilerExtension
extends AbstractNativeDecompilerExtension {
    public ChainedOperationResult<Boolean> customizeIntermediateOptimizer(INativeDecompilerUnit<?> decompiler, EMasterOptimizer optimizer) {
        optimizer.addDisregardedOutputFilter(new IOptFilterCanDiscard(){

            public boolean check(CFG<IEStatement> cfg, long insnAddress, int regDef) {
                return regDef < 0;
            }
        });
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    public ChainedOperationResult<Boolean> applyAdditionalTypes(INativeDecompilationTarget target, CFG<IEStatement> cfg) {
        IWildcardTypeManager etypeman = target.getDecompiler().getWildcardTypeManager();
        IWildcardType tBool = etypeman.create("bool");
        IWildcardType tAddress = etypeman.create("address");
        for (IEStatement stm : cfg.instructions()) {
            IEUntranslatedInstruction u;
            if (!(stm instanceof IEUntranslatedInstruction) || !((u = (IEUntranslatedInstruction)stm).getTag() instanceof Integer)) continue;
            Libra.OpcodeDef opcode = Libra.OpcodeDef.fromValue((Integer)u.getTag());
            switch (opcode) {
                case ASSERT: {
                    u.getParameterExpression(1).setType(tBool);
                    break;
                }
                case GET_TXN_SENDER: {
                    u.getResultExpression().setType(tAddress);
                    break;
                }
            }
        }
        return ChainedOperationResult.TRUE_CONTINUE;
    }
}

