/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.androidjnihelper;

import com.pnf.plugin.androidjnihelper.DynamicJNIDetectionHeurFromMethodName;
import com.pnf.plugin.androidjnihelper.DynamicJNIDetectionHeurFromSignature;
import com.pnf.plugin.androidjnihelper.DynamicJNIDetectionHeurRegisterNatives;
import com.pnf.plugin.androidjnihelper.IDynamicJNIDetectionHeuritic;
import com.pnf.plugin.androidjnihelper.JNINativeMethod;
import com.pnf.plugin.androidjnihelper.JNIReport;
import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.DexUtil;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.IJniEndpoint;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamicJNIDetectionPlugin
extends AbstractEnginesPlugin {
    static final ILogger logger = GlobalLog.getLogger(DynamicJNIDetectionPlugin.class);
    private JNIReport report;
    private IDynamicJNIDetectionHeuritic[] heuristics = new IDynamicJNIDetectionHeuritic[]{new DynamicJNIDetectionHeurRegisterNatives(), new DynamicJNIDetectionHeurFromMethodName(), new DynamicJNIDetectionHeurFromSignature()};

    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Dynamic JNI Detection Plugin", "Heuristically discover dynamically loaded JNI function and enable JEB to use them (debug)", "PNF Software", Version.create((int)1, (int)0, (int)2), Version.create((int)3, (int)4, (int)0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IEnginesContext context, Map<String, String> executionOptions) {
        try {
            this.report = new JNIReport();
            this.executeInternal(context, executionOptions);
        }
        catch (Exception e) {
            logger.error("An error occurred while executing the plugin", new Object[0]);
            logger.catchingSilent((Throwable)e);
            JebCoreService.notifySilentExceptionToClient((Throwable)e);
        }
        finally {
            logger.info(this.report.getReport(), new Object[0]);
        }
    }

    private void executeInternal(IEnginesContext context, Map<String, String> executionOptions) {
        List<IApkUnit> apkUnits = this.getApkUnits(context);
        if (apkUnits.isEmpty()) {
            logger.info("No apk candidate can be found", new Object[0]);
            return;
        }
        for (IApkUnit apk : apkUnits) {
            IUnit libs = apk.getLibrariesUnit();
            if (libs == null) {
                logger.info("Native libraries not found", new Object[0]);
                continue;
            }
            List<IUnit> candidates = this.getCandidateAbis(libs);
            if (candidates == null || candidates.isEmpty()) continue;
            for (IUnit candidate : candidates) {
                IELFUnit elf;
                List<IDexMethod> nativeMethods = this.getNativeMethods(apk.getDex());
                List sos = candidate.getChildren();
                if (nativeMethods.isEmpty()) continue;
                ArrayList<JNINativeMethod> allFunctions = new ArrayList<JNINativeMethod>();
                for (IUnit so : sos) {
                    if (so instanceof IELFUnit) {
                        IUnit image;
                        elf = (IELFUnit)so;
                        logger.debug("Processing %s:%s", new Object[]{elf.getName(), elf.getLoaderInformation().getTargetProcessor()});
                        ISymbolInformation onload = null;
                        List symbols = elf.getExportedSymbols();
                        for (ISymbolInformation sym : symbols) {
                            if (!sym.getName().equals("JNI_OnLoad")) continue;
                            onload = sym;
                            break;
                        }
                        if (onload == null || !((image = elf.getImageUnit()) instanceof INativeCodeUnit)) continue;
                        INativeCodeUnit codeUnit = (INativeCodeUnit)image;
                        if (!codeUnit.isProcessed()) {
                            codeUnit.process();
                        }
                        if (!codeUnit.isInitialAnalysisDone()) {
                            codeUnit.performInitialAnalysis();
                        }
                        while (!codeUnit.isAnalysisCompleted()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                logger.catching((Throwable)e);
                                break;
                            }
                        }
                        for (IDynamicJNIDetectionHeuritic h : this.heuristics) {
                            List<JNINativeMethod> functions = h.determine(codeUnit, nativeMethods, onload);
                            allFunctions.addAll(functions);
                        }
                        continue;
                    }
                    logger.error("Can not proceed with unit %s", new Object[]{so});
                }
                this.sanitize(allFunctions);
                for (JNINativeMethod jni : allFunctions) {
                    this.processJNIMethod(apk, nativeMethods, jni, candidate.getName());
                }
                for (IUnit so : sos) {
                    if (!(so instanceof IELFUnit)) continue;
                    elf = (IELFUnit)so;
                    List symbols = elf.getExportedSymbols();
                    for (ISymbolInformation sym : symbols) {
                        if (!sym.getName().startsWith("Java_")) continue;
                        block11: for (int i = 0; i < nativeMethods.size(); ++i) {
                            String[] names;
                            IDexMethod m = nativeMethods.get(i);
                            String sig = m.getSignature(true);
                            for (String name : names = DexUtil.toJniName((String)sig)) {
                                if (!name.equals(sym.getName())) continue;
                                logger.debug("Found static JNI method: %s", new Object[]{sym.getName()});
                                this.report.saveStaticMethod(apk, (IUnit)elf, sig, candidate.getName(), sym);
                                nativeMethods.remove(i);
                                continue block11;
                            }
                        }
                    }
                }
                if (nativeMethods.isEmpty()) continue;
                for (int i = 0; i < nativeMethods.size(); ++i) {
                    IDexMethod m = nativeMethods.get(i);
                    String methodName = m.getSignature(true);
                    logger.debug("JNI method not found: %s", new Object[]{methodName});
                    this.report.saveMissingMethod(apk, methodName, candidate.getName());
                }
            }
        }
    }

    private void sanitize(List<JNINativeMethod> functions) {
        for (int i = 0; i < functions.size(); ++i) {
            boolean removeAtEnd = false;
            JNINativeMethod elt1 = functions.get(i);
            for (int j = i + 1; j < functions.size(); ++j) {
                JNINativeMethod elt2 = functions.get(j);
                if (!elt1.name.equals(elt2.name) || !elt1.signature.equals(elt2.signature)) continue;
                functions.remove(j);
                --j;
                if (elt1.codeUnit == elt2.codeUnit && elt1.fnPtr == elt2.fnPtr) continue;
                removeAtEnd = true;
            }
            if (!removeAtEnd) continue;
            logger.error("Found duplicate native method references for %s", new Object[]{elt1.name});
            functions.remove(i);
            --i;
        }
    }

    private List<IDexMethod> getNativeMethods(IDexUnit dex) {
        ArrayList<IDexMethod> natives = new ArrayList<IDexMethod>();
        for (IDexClass c : dex.getClasses()) {
            List methods = c.getMethods();
            if (methods == null) continue;
            for (IDexMethod m : c.getMethods()) {
                if ((m.getGenericFlags() & 0x100) == 0) continue;
                natives.add(m);
            }
        }
        return natives;
    }

    static String readStringUTF8(IVirtualMemory vm, long ptrMethods) throws MemoryException {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean endCharDetected = false;
        block0: do {
            int read = vm.read(ptrMethods, buffer.length, buffer, 0);
            for (int i = 0; i < read; ++i) {
                if (buffer[i] == 0) {
                    endCharDetected = true;
                    continue block0;
                }
                bos.write(buffer[i]);
            }
        } while (!endCharDetected);
        return new String(bos.toByteArray(), Charset.forName("UTF-8"));
    }

    private List<IUnit> getCandidateAbis(IUnit libs) {
        ArrayList<IUnit> candidates = new ArrayList<IUnit>();
        for (IUnit lib : libs.getChildren()) {
            if (!lib.getName().contains("arm")) continue;
            candidates.add(lib);
        }
        return candidates;
    }

    private List<IApkUnit> getApkUnits(IEnginesContext context) {
        ArrayList<IApkUnit> apks = new ArrayList<IApkUnit>();
        for (IRuntimeProject prj : context.getProjects()) {
            for (ILiveArtifact art : prj.getLiveArtifacts()) {
                this.getApkUnits(art.getUnits(), apks);
            }
        }
        return apks;
    }

    private void getApkUnits(List<? extends IUnit> units, List<IApkUnit> apks) {
        if (units == null) {
            return;
        }
        for (IUnit iUnit : units) {
            if (iUnit instanceof IApkUnit) {
                apks.add((IApkUnit)iUnit);
            }
            this.getApkUnits(iUnit.getChildren(), apks);
        }
    }

    protected boolean processJNIMethod(IApkUnit apk, List<IDexMethod> nativeMethods, JNINativeMethod jni, String libName) {
        INativeType dataType;
        INativeItem item;
        logger.debug("JNI Method: %s %s %xh", new Object[]{jni.name, jni.signature, jni.fnPtr});
        boolean thumb = (jni.fnPtr & 1L) != 0L;
        String methodAddress = Long.toHexString(thumb ? jni.fnPtr - 1L : jni.fnPtr) + "h";
        String newComment = Strings.f((String)"JNI method Detected: %s %s", (Object[])new Object[]{jni.name, jni.signature});
        this.appendComment((IInteractiveUnit)jni.codeUnit, methodAddress, newComment);
        IDexUnit dex = apk.getDex();
        IDexMethod m = this.getDexMethod(nativeMethods, jni);
        if (m == null) {
            logger.error("Can not define JNI method @%Xh", new Object[]{jni.fnPtr});
            return false;
        }
        IUnit elf = (IUnit)jni.codeUnit.getParent();
        newComment = Strings.f((String)"%s is registered dynamically, it references native routine @%Xh in file %s/%s", (Object[])new Object[]{jni.name, jni.fnPtr, elf.getParent().getName(), elf.getName()});
        this.appendComment((IInteractiveUnit)dex, m.getAddress(), newComment);
        String signature = m.getSignature(true);
        List endpoints = apk.dynamic().getJniMethods(signature);
        boolean alreadyDefined = false;
        if (endpoints != null) {
            for (IJniEndpoint endpoint : endpoints) {
                if (endpoint.isStatic() || endpoint.getUnit() != elf) continue;
                alreadyDefined = true;
                break;
            }
        }
        if (!alreadyDefined) {
            apk.dynamic().registerDynamicJni(signature, elf, jni.fnPtr);
        }
        if ((item = jni.codeUnit.getItemObject(jni.codeUnit.getItemAtAddress(methodAddress))) == null || !(item instanceof INativeMethodItem)) {
            jni.codeUnit.setRoutineAt(jni.fnPtr);
            item = jni.codeUnit.getItemObject(jni.codeUnit.getItemAtAddress(methodAddress));
            if (item == null || !(item instanceof INativeMethodItem)) {
                logger.error("Can not define JNI method @%Xh", new Object[]{jni.fnPtr});
                return true;
            }
        }
        INativeMethodItem method = (INativeMethodItem)item;
        String oldMethodName = method.getName(true);
        String methodName = null;
        if (oldMethodName.startsWith("sub_") && !jni.name.startsWith("sub_") && jni.codeUnit.getMethod(methodName = "__jni_" + jni.name + "_" + jni.signature) == null) {
            method.setName(methodName);
            if (method.getName(true).startsWith("__jni_")) {
                logger.debug("Method %s was renamed to %s", new Object[]{oldMethodName, methodName});
            }
        }
        if ((dataType = jni.codeUnit.getTypeManager().getType("void*")) != null) {
            jni.codeUnit.setDataAt(jni.ptrName, dataType, "__jni_ptr_" + jni.name);
            jni.codeUnit.setDataTypeAt(jni.ptrSignature, dataType);
            jni.codeUnit.setDataTypeAt(jni.ptrFnPtr, dataType);
        }
        this.report.saveDynamicMethodMatch(apk, elf, signature, libName, jni, oldMethodName, methodName);
        return true;
    }

    private void appendComment(IInteractiveUnit unit, String address, String newComment) {
        String comment = unit.getComment(address);
        if (comment != null) {
            newComment = comment.contains(newComment) ? comment : comment + "\n" + newComment;
        }
        unit.setComment(address, newComment);
    }

    private IDexMethod getDexMethod(List<IDexMethod> nativeMethods, JNINativeMethod jni) {
        for (int i = 0; i < nativeMethods.size(); ++i) {
            String classSig;
            int argStart;
            IDexMethod m = nativeMethods.get(i);
            if (!m.getName(true).equals(jni.name) || (argStart = (classSig = m.getSignature(true)).indexOf("(")) < 0 || !classSig.substring(argStart).equals(jni.signature)) continue;
            nativeMethods.remove(m);
            return m;
        }
        return null;
    }
}

