/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfStream;
import java.util.List;

public abstract class PdfHierarchyProcessor<T> {
    public void browseElement(IPdfAttribute attribute, T t) {
        switch (attribute.getType()) {
            case Array: {
                this.browseArray(((PdfArray)attribute).getAttributes(), t);
                break;
            }
            case Boolean: 
            case Name: 
            case Null: 
            case Number: 
            case String: 
            case Unknown: {
                this.processSimpleObject(attribute, t);
                break;
            }
            case IndirectReference: {
                this.processIndirectReference(attribute, t);
                break;
            }
            case Stream: {
                this.browseDictionaryChildren(((PdfStream)attribute).getDictionary().getAttributes(), t);
                break;
            }
            case Dictionary: {
                this.browseDictionaryChildren(((PdfDictionary)attribute).getAttributes(), t);
                break;
            }
        }
    }

    private void browseArray(List<IPdfAttribute> attributes, T t) {
        int i = 0;
        for (IPdfAttribute attribute : attributes) {
            boolean recursive = this.processArrayElement(attribute, i, t);
            if (recursive) {
                this.browseElement(attribute, t);
            }
            ++i;
        }
    }

    private void browseDictionaryChildren(List<PdfDictionaryAttribute> attributes, T t) {
        for (PdfDictionaryAttribute attribute : attributes) {
            boolean recursive = this.processDictionaryAttribute(attribute, t);
            if (!recursive) continue;
            this.browseElement(attribute.getValue(), t);
        }
    }

    public abstract void processSimpleObject(IPdfAttribute var1, T var2);

    public abstract void processIndirectReference(IPdfAttribute var1, T var2);

    public abstract boolean processArrayElement(IPdfAttribute var1, int var2, T var3);

    public abstract boolean processDictionaryAttribute(PdfDictionaryAttribute var1, T var2);
}

