/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.filter.ByteBufferUtils;
import com.pnf.plugin.pdf.filter.Decoder;
import com.pnf.plugin.pdf.filter.FilterFactory;
import com.pnf.plugin.pdf.filter.IFilter;
import com.pnf.plugin.pdf.filter.PDFObject;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfIndirectOjbStm;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfName;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfString;
import com.pnf.plugin.pdf.obj.PdfXref;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Ser
public class PdfStream
extends AbstractPdfParsableAttribute
implements Comparable<PdfStream> {
    private static final ILogger logger = GlobalLog.getLogger(PdfStream.class);
    @SerId(value=1)
    private PdfDictionary dictionary;
    @SerId(value=2)
    private byte[] encodedData;
    @SerId(value=3)
    private byte[] decodedData;
    @SerId(value=4)
    private List<byte[]> encodedDataList = new ArrayList<byte[]>();
    @SerId(value=5)
    private StreamType streamType;
    @SerId(value=6)
    private int fromByte;
    @SerId(value=7)
    private int toByte;
    @SerId(value=8)
    private Map<PdfObjId, PdfIndirectObj> objStmChildren = null;
    @SerId(value=9)
    private Map<PdfObjId, PdfIndirectObj> extendedByObjects = null;
    @SerTransient
    private PdfXref xref;
    @SerTransient
    private byte[] extraChars = new byte[2];

    @SerCustomInit
    private void init() {
        this.extraChars = new byte[2];
    }

    public PdfStream(PdfDictionary dictionary, int startIndex) {
        super(dictionary.getParent(), startIndex);
        this.dictionary = dictionary;
    }

    public PdfStream(PdfDictionary dictionary, List<PdfStream> xfaFragments) throws IOException {
        super(dictionary.getParent(), dictionary.getStartIndex());
        this.dictionary = dictionary;
        ByteArrayOutputStream encodedDataByteArray = new ByteArrayOutputStream();
        for (PdfStream xfaStream : xfaFragments) {
            encodedDataByteArray.write(xfaStream.getDecodedData());
        }
        this.encodedData = encodedDataByteArray.toByteArray();
        this.decodedData = this.encodedData;
    }

    public PdfStream(PdfDictionary dictionary, PdfString pdfString) {
        this(dictionary, pdfString.toString().getBytes());
    }

    public PdfStream(PdfDictionary dictionary, byte[] data) {
        super(dictionary.getParent(), dictionary.getStartIndex());
        this.dictionary = dictionary;
        this.encodedData = data;
        this.decodedData = this.encodedData;
    }

    @Override
    public int parse(byte[] data, int cursor) {
        this.fromByte = cursor = this.retrieveStartOfStream(data, cursor);
        while (cursor < data.length && !this.isEndToken(data, cursor)) {
            ++cursor;
        }
        this.toByte = this.retrieveEndOfStream(data, cursor);
        if (this.toByte < this.fromByte) {
            this.toByte = this.fromByte - 1;
        }
        this.encodedData = new byte[this.getParsedLength()];
        System.arraycopy(data, this.fromByte, this.encodedData, 0, this.getParsedLength());
        if (this.toByte + 2 < data.length) {
            this.extraChars[0] = data[this.toByte + 1];
            this.extraChars[1] = data[this.toByte + 2];
        }
        return cursor;
    }

    private int retrieveStartOfStream(byte[] data, int cursor) {
        ++cursor;
        int endLine = PdfSpecialCharacters.testEndLine(data, cursor += PdfSpecialCharacters.STREAM_START_SEPARATOR.length);
        if (endLine == 0) {
            logger.error("Stream begins at end of stream", new Object[0]);
        } else if (endLine == -1) {
            logger.warn("Missing EOL character after stream token at address %x", new Object[]{cursor});
        } else {
            cursor += endLine;
        }
        return cursor;
    }

    private int retrieveEndOfStream(byte[] data, int cursor) {
        int endLine;
        if ((endLine = PdfSpecialCharacters.testPreviousEndLine(data, --cursor)) != -1) {
            cursor -= endLine;
        }
        return cursor;
    }

    public boolean isEndToken(byte[] data, int cursor) {
        return PdfSpecialCharacters.isEndStream(data, cursor);
    }

    public String getName() {
        StringBuilder stb = new StringBuilder(this.getId().toString());
        String type = this.getStreamType();
        if (!Strings.isBlank((String)type)) {
            stb.append(" (").append(type).append(")");
        }
        return stb.toString();
    }

    public String toString() {
        return String.format("Stream %s", this.dictionary.toString());
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.Stream;
    }

    public PdfDictionary getDictionary() {
        return this.dictionary;
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }

    public byte[] getDecodedData() {
        if (this.decodedData == null) {
            this.decodeStream();
        }
        return this.decodedData;
    }

    public IPdfAttribute getAttribute(String name) {
        return this.dictionary.getAttribute(name);
    }

    public Integer getLengthFromDictionary() {
        IPdfAttribute attribute = this.getAttribute("/Length");
        if (attribute != null) {
            if (attribute.getType() == IPdfAttribute.Type.Number) {
                return Integer.valueOf(attribute.toString());
            }
            this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, String.format("Unable to parse [Stream %s]/Length: expected number", this.getId()));
        }
        return null;
    }

    public int getParsedLength() {
        return this.toByte - this.fromByte + 1;
    }

    public List<IFilter> getFilters(IPdfAttribute decodeParms, PDFDecrypter decrypter) {
        return this.getFilters(this.getAttribute("/Filter"), decodeParms, decrypter);
    }

    private List<IFilter> getFilters(IPdfAttribute attribute, IPdfAttribute decodeParms, PDFDecrypter decrypter) {
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        if (attribute != null) {
            if (attribute.getType() == IPdfAttribute.Type.Name) {
                filters.add(FilterFactory.getFilterInstance(this, (PdfName)attribute, decodeParms, this.getPdfStatictics(), decrypter));
            } else if (attribute.getType() == IPdfAttribute.Type.Array) {
                PdfArray array = (PdfArray)attribute;
                if (array.getAttributes().size() > 1) {
                    this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.StreamWithMultipleFilters, String.format("[Stream %s] has several filters", this.getId()));
                }
                PdfArray decodeParmsArray = null;
                if (decodeParms != null && decodeParms.getType() != IPdfAttribute.Type.Array) {
                    this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, String.format("Unable to parse [Stream %s]/DecodeParms: expected array", this.getId()));
                    decodeParms = null;
                } else {
                    decodeParmsArray = (PdfArray)decodeParms;
                }
                for (int i = 0; i < array.getAttributes().size(); ++i) {
                    filters.addAll(this.getFilters(array.getAttributes().get(i), this.getDecodeParms(decodeParmsArray, i), decrypter));
                }
            } else {
                this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, String.format("Unable to parse [Stream %s]/Filter: expected name or array", this.getId()));
            }
        }
        return filters;
    }

    private IPdfAttribute getDecodeParms(PdfArray decodeParmsArray, int i) {
        if (decodeParmsArray == null || decodeParmsArray.getAttributes().size() <= i) {
            return null;
        }
        IPdfAttribute attribute = decodeParmsArray.getAttributes().get(i);
        if (attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            return PdfIndirectReference.retrieveDirectObject(attribute);
        }
        return attribute;
    }

    public void decodeStream() {
        IPdfAttribute decodeParms;
        List<IFilter> filters;
        if (this.decodedData != null) {
            return;
        }
        PDFDecrypter decrypter = this.getMainParent().getDecrypter();
        boolean isEncrypted = this.isEncrypted();
        IPdfAttribute extFile = this.getAttribute("/F");
        if (extFile != null && extFile.getType() != IPdfAttribute.Type.Null) {
            this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.StreamUnfiltered, "External Stream data is not implemented");
            this.decodedData = new byte[0];
            return;
        }
        byte[] rawData = this.encodedData;
        if (isEncrypted) {
            this.encodedDataList.add(rawData);
            if (decrypter != null) {
                ByteBuffer in = ByteBufferUtils.getByteBuffer(rawData, 0, this.getParsedLength());
                try {
                    ByteBuffer out = decrypter.decryptBuffer(null, PDFObject.getInstance(this.getParent()), in);
                    rawData = out.array();
                }
                catch (PDFParseException e) {
                    logger.catching((Throwable)e);
                    this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.StreamUnfiltered, "Encrypted");
                    this.decodedData = new byte[0];
                    return;
                }
            } else {
                this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.StreamUnfiltered, "Encrypted");
                this.decodedData = new byte[0];
                return;
            }
        }
        if ((filters = this.getFilters(decodeParms = this.getAttribute("/DecodeParms"), decrypter)).isEmpty()) {
            this.decodedData = rawData;
        } else {
            Decoder d = new Decoder(this.dictionary);
            this.encodedDataList.add(rawData);
            try {
                rawData = isEncrypted ? d.parse(0, filters.get(0), rawData) : d.parse(0, filters.get(0), rawData, this.encodedData, this.fromByte, this.getLengthFromDictionary());
                if (filters.size() > 1) {
                    this.encodedDataList.add(rawData);
                    for (int i = 1; i < filters.size(); ++i) {
                        if (rawData.length == 0) {
                            this.decodedData = new byte[0];
                            return;
                        }
                        rawData = d.parse(i, filters.get(i), rawData);
                        if (i >= filters.size() - 1) continue;
                        this.encodedDataList.add(rawData);
                    }
                }
                this.decodedData = rawData.length != 0 ? rawData : new byte[0];
                if (this.isDecodedStreamTooBig()) {
                    this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.PotentialHarmfulFile, String.format("Decoded stream is %d Mb", this.decodedData.length / 1000000, this.getMaxDecodedSize() / 1000000));
                }
                if (d.getDecodingError() != null) {
                    logger.error("Unable to parse Stream %s over filter [%d] error while decoding: %s. Processed bytes: %d", new Object[]{this.getId(), d.getFilterIndex(), d.getDecodingError(), d.getDecodingError().getProcessed()});
                    this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.MalformedStream, "Unable to parse Stream: filter failed");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to parse Stream %s can not be read: %s", new Object[]{this.getId(), e.getMessage()});
                this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.MalformedStream, "Unable to parse Stream: filter failed");
                this.decodedData = new byte[0];
            }
        }
    }

    public void checkSize() {
        Integer lengthFromDictionary = this.getLengthFromDictionary();
        if (lengthFromDictionary == null) {
            logger.warn("No Length defined. Parser found %d", new Object[]{this.getParsedLength()});
        } else if (this.getParsedLength() != lengthFromDictionary.intValue()) {
            boolean lastIsEOL;
            boolean extraEOL = PdfSpecialCharacters.isEndLine(this.extraChars[0]);
            boolean extra2ndEOL = PdfSpecialCharacters.isEndLine(this.extraChars[1]);
            boolean bl = this.encodedData.length > 0 ? this.encodedData[this.getParsedLength() - 1] == 13 : (lastIsEOL = true);
            if (!(this.getParsedLength() + 1 == lengthFromDictionary && extraEOL || this.getParsedLength() + 2 == lengthFromDictionary && extraEOL && extra2ndEOL || this.getParsedLength() == lengthFromDictionary + 1 && lastIsEOL)) {
                logger.warn("Length defined: %s. Parser found %d", new Object[]{lengthFromDictionary.toString(), this.getParsedLength()});
            }
        }
    }

    private PdfName getLastFilter() {
        IPdfAttribute filter = this.getAttribute("/Filter");
        if (filter == null) {
            return null;
        }
        if (filter.getType() == IPdfAttribute.Type.Name) {
            return (PdfName)filter;
        }
        if (filter.getType() == IPdfAttribute.Type.Array) {
            List<IPdfAttribute> filters = ((PdfArray)filter).getAttributes();
            return (PdfName)PdfDictionary.retrieveDirectObject(filters.get(filters.size() - 1));
        }
        return null;
    }

    public boolean isBinaryOnlyDisplay() {
        return this.isDecodedStreamTooBig() || this.getStreamType().endsWith("Image");
    }

    private boolean isDecodedStreamTooBig() {
        return this.decodedData != null && this.decodedData.length > this.getMaxDecodedSize();
    }

    private int getMaxDecodedSize() {
        return 10000000;
    }

    public String getWantedType() {
        if (this.streamType == null) {
            return null;
        }
        switch (this.streamType) {
            case Javascript: {
                return "javascript";
            }
            case XML: {
                return "xml";
            }
        }
        return null;
    }

    public String getStreamType() {
        if (this.streamType != null) {
            return this.streamType.toString();
        }
        if (this.dictionary.getDictionaryFullType() != null) {
            return this.dictionary.getDictionaryFullType();
        }
        if (this.decodedData != null) {
            StreamType type = StreamType.getStreamType(this.decodedData);
            if (type == StreamType.Stream) {
                // empty if block
            }
            return type.toString();
        }
        return StreamType.Stream.toString();
    }

    public void addObjStmChild(PdfIndirectOjbStm newobj) {
        if (this.objStmChildren == null) {
            this.objStmChildren = new HashMap<PdfObjId, PdfIndirectObj>();
        }
        this.objStmChildren.put(newobj.getId(), newobj);
    }

    public List<PdfObjId> getObjStmId() {
        if (this.objStmChildren == null) {
            return new ArrayList<PdfObjId>();
        }
        ArrayList<PdfObjId> ids = new ArrayList<PdfObjId>(this.objStmChildren.keySet());
        Collections.sort(ids);
        return ids;
    }

    public boolean isObjStm() {
        return "/ObjStm".equals(this.getDictionary().getDictionaryType());
    }

    public List<PdfIndirectObj> getObjStmList() {
        if (this.objStmChildren == null) {
            return new ArrayList<PdfIndirectObj>();
        }
        ArrayList<PdfIndirectObj> list = new ArrayList<PdfIndirectObj>(this.objStmChildren.values());
        Collections.sort(list);
        return list;
    }

    public void addExtendedBy(PdfIndirectObj stream) {
        if (this.extendedByObjects == null) {
            this.extendedByObjects = new HashMap<PdfObjId, PdfIndirectObj>();
        }
        this.extendedByObjects.put(stream.getId(), stream);
    }

    public boolean hasExtendedStream() {
        return this.extendedByObjects != null;
    }

    public boolean isObjStmExtends() {
        return this.isObjStm() && this.getAttribute("/Extends") != null;
    }

    public List<PdfIndirectObj> getExtendedByList() {
        if (this.extendedByObjects == null) {
            return new ArrayList<PdfIndirectObj>();
        }
        ArrayList<PdfIndirectObj> list = new ArrayList<PdfIndirectObj>(this.extendedByObjects.values());
        Collections.sort(list);
        return list;
    }

    public List<byte[]> getEncodedDataList() {
        return this.encodedDataList;
    }

    public void setType(StreamType type) {
        this.streamType = type;
    }

    public boolean isEncrypted() {
        boolean isEncrypted = this.getMainParent().isEncrypted();
        if ("/XRef".equals(this.dictionary.getDictionaryType())) {
            isEncrypted = false;
        }
        return isEncrypted;
    }

    public String getAsText() {
        if (this.decodedData == null || this.decodedData.length == 0) {
            return null;
        }
        if ("/XRef".equals(this.dictionary.getDictionaryType())) {
            try {
                if (this.xref == null) {
                    this.xref = new PdfXref(this);
                }
                return this.xref.getXRefText();
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
                return null;
            }
        }
        return null;
    }

    public boolean isImage() {
        return this.getStreamType().equals("/XObject/Image");
    }

    public boolean isJpeg() {
        PdfName lastFilter = this.getLastFilter();
        return this.isImage() && lastFilter != null && (lastFilter.toString().equals("/DCTDecode") || lastFilter.toString().equals("/DCT"));
    }

    @Override
    public int compareTo(PdfStream o) {
        return this.getId().compareTo(o.getId());
    }

    @Ser
    public static enum StreamType {
        XML(new byte[][]{"<?xpacket".getBytes(), "<?xml".getBytes()}),
        ADOBE_FONT("%!PS-AdobeFont".getBytes()),
        Flash(new byte[][]{"CWS".getBytes(), "FWS".getBytes(), "ZWS".getBytes()}),
        U3D("U3D".getBytes()),
        Stream("".getBytes()),
        Javascript("".getBytes()),
        Script("".getBytes()),
        Contents("".getBytes()),
        XFA_Fragment("".getBytes()),
        XFA("".getBytes());

        private byte[][] startBy;

        private StreamType(byte[][] startBy) {
            this.startBy = startBy;
        }

        private StreamType(byte[] startBy) {
            this.startBy = new byte[][]{startBy};
        }

        public byte[][] getStartBy() {
            return this.startBy;
        }

        public static StreamType getStreamType(byte[] data) {
            for (StreamType type : StreamType.values()) {
                if (!StreamType.isType(data, type)) continue;
                return type;
            }
            return Stream;
        }

        private static boolean isType(byte[] data, StreamType type) {
            for (byte[] startBy : type.getStartBy()) {
                boolean isType = true;
                for (int i = 0; i < startBy.length; ++i) {
                    if (i < data.length && data[i] == startBy[i]) continue;
                    isType = false;
                    break;
                }
                if (!isType) continue;
                return true;
            }
            return false;
        }
    }
}

