/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.filter;

import com.pnf.plugin.pdf.filter.ByteBufferUtils;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.sun.pdfview.PDFStringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PDFObject {
    private static final IPdfAttribute.Type ARRAY = IPdfAttribute.Type.Array;
    private static final IPdfAttribute.Type INDIRECT = IPdfAttribute.Type.IndirectReference;
    private static final IPdfAttribute.Type DICTIONARY = IPdfAttribute.Type.Dictionary;
    private static final IPdfAttribute.Type STREAM = IPdfAttribute.Type.Stream;
    private static final IPdfAttribute.Type NUMBER = IPdfAttribute.Type.Number;
    private static final IPdfAttribute.Type BOOLEAN = IPdfAttribute.Type.Boolean;
    private static final IPdfAttribute.Type NAME = IPdfAttribute.Type.Name;
    private static final IPdfAttribute.Type STRING = IPdfAttribute.Type.String;
    private IPdfAttribute dict;
    private IPdfAttribute.Type type;
    private SoftReference<Object> cache;

    private PDFObject(IPdfAttribute dict) {
        this.dict = dict;
        this.type = dict.getType();
    }

    public static PDFObject getInstance(IPdfAttribute dict) {
        if (dict == null) {
            return null;
        }
        return new PDFObject(dict);
    }

    public int getObjNum() {
        return this.dict.getId().getObjectNumber();
    }

    public int getObjGen() {
        return this.dict.getId().getGenerationNumber();
    }

    public IPdfAttribute.Type getType() {
        return this.dict.getType();
    }

    public PDFObject getDictRef(String key) throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getDictRef(key);
        }
        if (this.type == DICTIONARY) {
            return PDFObject.getInstance(((PdfDictionary)this.dict).getAttribute("/" + key));
        }
        if (this.type == STREAM) {
            return PDFObject.getInstance(((PdfStream)this.dict).getAttribute("/" + key));
        }
        return null;
    }

    public int getIntValue() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getIntValue();
        }
        if (this.type == NUMBER) {
            try {
                return Integer.valueOf(this.dict.toString());
            }
            catch (Exception e) {
                try {
                    return Long.valueOf(this.dict.toString()).intValue();
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    public boolean getBooleanValue() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getBooleanValue();
        }
        if (this.type == BOOLEAN) {
            return Boolean.valueOf(this.dict.toString());
        }
        return false;
    }

    public PDFObject getAt(int i) throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getAt(i);
        }
        if (this.type == ARRAY) {
            return PDFObject.getInstance(((PdfArray)this.dict).getAttributes().get(i));
        }
        return null;
    }

    public float getFloatValue() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getFloatValue();
        }
        if (this.type == NUMBER) {
            return Double.valueOf(this.dict.toString()).floatValue();
        }
        return 0.0f;
    }

    public String getStringValue() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getStringValue();
        }
        if (this.type == STRING) {
            return this.dict.toString();
        }
        if (this.type == NAME) {
            return this.dict.toString().substring(1);
        }
        return null;
    }

    public HashMap<String, PDFObject> getDictionary() throws IOException {
        List<PdfDictionaryAttribute> dictAttributes = null;
        if (this.type == INDIRECT) {
            return this.dereference().getDictionary();
        }
        if (this.type == DICTIONARY) {
            dictAttributes = ((PdfDictionary)this.dict).getAttributes();
        } else if (this.type == STREAM) {
            dictAttributes = ((PdfStream)this.dict).getDictionary().getAttributes();
        } else {
            return new HashMap<String, PDFObject>();
        }
        HashMap<String, PDFObject> dictionary = new HashMap<String, PDFObject>();
        for (PdfDictionaryAttribute att : dictAttributes) {
            dictionary.put(att.getKey().toString().substring(1), PDFObject.getInstance(att.getValue()));
        }
        return dictionary;
    }

    public InputStream getUnfilteredStream() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getUnfilteredStream();
        }
        if (this.type == STREAM) {
            return new ByteArrayInputStream(((PdfStream)this.dict).getDecodedData());
        }
        return null;
    }

    public String toString() {
        return this.dict.toString();
    }

    public byte[] getStream() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getStream();
        }
        if (this.type == STREAM) {
            PdfStream stream = (PdfStream)this.dict;
            if (stream == null) {
                return null;
            }
            return stream.getDecodedData();
        }
        if (this.type == STRING) {
            return PDFStringUtil.asBytes(this.getStringValue());
        }
        return null;
    }

    public Iterator<String> getDictKeys() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getDictKeys();
        }
        if (this.type == DICTIONARY) {
            return ((PdfDictionary)this.dict).getAttributeKeys().iterator();
        }
        if (this.type == STREAM) {
            return ((PdfStream)this.dict).getDictionary().getAttributeKeys().iterator();
        }
        return new ArrayList().iterator();
    }

    public PDFObject[] getArray() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getArray();
        }
        if (this.type == ARRAY) {
            List<IPdfAttribute> atts = ((PdfArray)this.dict).getAttributes();
            PDFObject[] result = new PDFObject[atts.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = PDFObject.getInstance(atts.get(i));
            }
            return result;
        }
        PDFObject[] ary = new PDFObject[]{this};
        return ary;
    }

    public ByteBuffer getStreamBuffer() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getStreamBuffer();
        }
        if (this.type == STREAM) {
            PdfStream stream = (PdfStream)this.dict;
            if (stream == null) {
                return null;
            }
            return ByteBufferUtils.getByteBuffer(stream.getDecodedData(), 0, stream.getDecodedData().length);
        }
        if (this.type == STRING) {
            String src = this.getStringValue();
            return ByteBuffer.wrap(src.getBytes());
        }
        return null;
    }

    public PDFObject dereference() {
        if (this.type == INDIRECT) {
            IPdfAttribute ref = PdfIndirectReference.retrieveDirectObject(this.dict);
            if (ref == null) {
                return null;
            }
            return PDFObject.getInstance(ref);
        }
        return this;
    }

    public Object getCache() throws IOException {
        if (this.type == INDIRECT) {
            return this.dereference().getCache();
        }
        if (this.cache != null) {
            return this.cache.get();
        }
        return null;
    }

    public void setCache(Object obj) throws IOException {
        if (this.type == INDIRECT) {
            this.dereference().setCache(obj);
            return;
        }
        this.cache = new SoftReference<Object>(obj);
    }
}

