/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.filter;

import com.pnf.plugin.pdf.filter.ByteBufferUtils;
import com.pnf.plugin.pdf.filter.FilterStreamException;
import com.pnf.plugin.pdf.filter.IFilter;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Crypt
implements IFilter {
    private PdfDictionary decodeParms;
    private PDFDecrypter decrypter;

    public Crypt(PdfDictionary decodeParms, PDFDecrypter decrypter) {
        this.decodeParms = decodeParms;
        this.decrypter = decrypter;
    }

    @Override
    public byte[] decodeBytes(byte[] data, int fromByte, int length, PdfDictionary dictionary) throws FilterStreamException {
        IPdfAttribute nameObj;
        String cfName = "Identity";
        if (this.decodeParms != null && (nameObj = this.decodeParms.getAttribute("/Name")) != null && nameObj.getType() == IPdfAttribute.Type.Name) {
            cfName = nameObj.toString().substring(1);
        }
        ByteBuffer bais = ByteBufferUtils.getByteBuffer(data, fromByte, length);
        try {
            ByteBuffer bb = this.decrypter.decryptBuffer(cfName, null, bais);
            return bb.array();
        }
        catch (IOException e) {
            throw new FilterStreamException(e);
        }
    }
}

