/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.StaticCodeTextDocument;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractControlFlowGraphFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.widgets.Composite;

public class StaticCodeGraphFragment
extends AbstractControlFlowGraphFragment<IUnit> {
    private static final ILogger logger = GlobalLog.getLogger(StaticCodeGraphFragment.class);
    private CFG<?> cfg;

    public StaticCodeGraphFragment(Composite parent, int style, RcpClientContext context, IUnit unit, IRcpUnitView unitView, CFG<?> initialCfg) {
        super(parent, style, unit, unitView, context);
        this.cfg = initialCfg;
    }

    @Override
    public boolean setFocus() {
        this.setCfg(this.cfg);
        return this.gp.setFocus();
    }

    @Override
    public boolean setActiveAddress(String address, Object extraAddressDetails, boolean recordPosition) {
        logger.warn("This graph does not support fine-grained addressing and positioning", new Object[0]);
        return false;
    }

    @Override
    protected boolean doItemFollow() {
        return false;
    }

    @Override
    protected ITextDocument getTextForBlock(BasicBlock<IInstruction> b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (IInstruction insn : b) {
            if (i >= 1) {
                sb.append("\n");
            }
            sb.append(String.format("%s", insn.format(null)));
            ++i;
        }
        String text = sb.toString();
        return new StaticCodeTextDocument((IUnit)this.getUnit(), b, text);
    }

    public void setCfg(CFG<?> cfg) {
        this.reset(true);
        this.cfg = cfg;
        if (cfg != null) {
            this.generateGraphForCFG(cfg);
        }
    }

    public CFG<?> getCfg() {
        return this.cfg;
    }
}

