/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.NativeCoordinates;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.CallGraphVertex;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICallGraph;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.Digraph;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.ICallgraphBuilder;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.collect.WeakValueMap;
import java.util.Iterator;
import java.util.List;

public class NativeCallgraphBuilder
implements ICallgraphBuilder {
    private INativeCodeUnit<IInstruction> unit;
    private Digraph model;
    private WeakValueMap<Integer, INativeMethodItem> vertexIdToMethodObject;
    private WeakIdentityHashMap<INativeMethodItem, Integer> methodObjectToVertexId;

    public NativeCallgraphBuilder(INativeCodeUnit<IInstruction> unit) {
        this.unit = unit;
    }

    @Override
    public Digraph buildModel() {
        List<INativeMethodItem> methods = this.unit.getInternalMethods();
        ICallGraph cg = this.unit.getCodeModel().getCallGraphManager().getGlobalCallGraph();
        MultiMap<Integer, Integer> mm = new MultiMap<Integer, Integer>();
        for (INativeMethodItem src : methods) {
            List<CallGraphVertex> dstlist = cg.getCallees(src, false);
            for (CallGraphVertex target : dstlist) {
                if (!target.isInternal()) continue;
                int i0 = methods.indexOf(src);
                INativeMethodItem dst = this.unit.getInternalMethod(target.getInternalAddress().getAddress(), true);
                if (dst == null) continue;
                int i1 = methods.indexOf(dst);
                if (mm.getSafe(i0).contains(i1)) continue;
                mm.put(i0, i1);
            }
        }
        this.model = new Digraph();
        this.vertexIdToMethodObject = new WeakValueMap();
        this.methodObjectToVertexId = new WeakIdentityHashMap();
        int i = 0;
        for (INativeMethodItem m : methods) {
            int insncnt = m.getData().getCFG().getInstructionCount();
            this.model.v(i, Double.valueOf(insncnt), m.getName(true));
            this.vertexIdToMethodObject.put(i, m);
            this.methodObjectToVertexId.put(m, i);
            ++i;
        }
        Iterator<INativeMethodItem> iterator = mm.keySet().iterator();
        while (iterator.hasNext()) {
            int i0 = (Integer)((Object)iterator.next());
            Iterator iterator2 = mm.getSafe(i0).iterator();
            while (iterator2.hasNext()) {
                int i1 = (Integer)iterator2.next();
                this.model.e(i0, i1);
            }
        }
        return this.model;
    }

    @Override
    public String getAddressForVertexId(int vertexId) {
        INativeMethodItem m;
        INativeMethodItem iNativeMethodItem = m = this.vertexIdToMethodObject == null ? null : this.vertexIdToMethodObject.get(vertexId);
        if (m == null) {
            return null;
        }
        return m.getAddress();
    }

    @Override
    public Integer getVertexIdForAddress(String address) {
        ICodeCoordinates cc = this.unit.getCodeCoordinatesFromAddress(address);
        INativeMethodItem m = null;
        if (cc instanceof MethodCoordinates) {
            int index = ((MethodCoordinates)cc).getMethodId();
            m = this.unit.getMethodByIndex(index);
        } else if (cc instanceof InstructionCoordinates) {
            int index = ((InstructionCoordinates)cc).getMethodId();
            m = this.unit.getMethodByIndex(index);
        } else if (cc instanceof NativeCoordinates) {
            long a = ((NativeCoordinates)cc).getAddress();
            m = this.unit.getInternalMethod(a, false);
        } else {
            return null;
        }
        if (m == null) {
            return null;
        }
        return this.methodObjectToVertexId.get(m);
    }
}

